package com.thebeastshop.pegasus.component.coupon.dao;

import java.util.List;

import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.dao.impl.CouponSampleDaoImpl;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponSampleImpl;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleEntity;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.mark.State;

/**
 * @author Liang Wenjian
 */
public interface CouponSampleDao {

	CouponSample create(CouponSample obj);

	boolean update(CouponSample obj);

	boolean decBalanceCount(CouponSample obj);

	boolean delete(Long id);

	CouponSample getById(long id);
	
	List<CouponSample> getByIds(List<Long> ids);

	CouponSample checkById(final long id) ;

	/**
	 * 获取优惠券样板所有的可能的状态。
	 *
	 * @return
	 */
	List<State> getStates();

	/**
	 *
	 * @return
	 */
	List<CouponSendWay> getCouponSendWays();

	List<AccessWay> getAccessWays();

	/**
	 * 根据条件获取优惠券模板列表
	 * 
	 * @param condition
	 * @return
	 */
	List<CouponSample> getByCondition(final CouponSampleCondition condition);

	List<CouponSample> getBySelectCondition(final CouponSampleCondition condition);

	/**
	 * 获取所有待一级审批的优惠券模板
	 *
	 * @return
	 */
	List<CouponSample> getFirstPendingCouponSample();

	/**
	 * 获取所有待二级审批的优惠券模板
	 *
	 * @return
	 */
	List<CouponSample> getSecondPendingCouponSample();

	/**
	 * 获取所有已经通过第一级审批的优惠券模板
	 *
	 * @return
	 */
	List<CouponSample> getFirstApprovaledCouponSample();

	/**
	 * 获取所有已经通过第二级审批的优惠券模板
	 *
	 * @return
	 */
	List<CouponSample> getSecondApprovaledCouponSample();

	/**
	 * 改变指定优惠券模板的状态为指定值
	 *
	 * @param id	待操作优惠券模板编号
	 *
	 * @param state	要改变为的状态
	 *
	 * @return
	 */
	Integer changeCouponSampleState(Long id, Integer state);

	/**
	 * 提交审批
	 *
	 * @param id
	 *
	 * @return
	 */
	Integer submitApproval(Long id);
}
