package com.thebeastshop.pegasus.component.coupon.service;

import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleThirdPartyCondition;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleThirdPartyEntity;

import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/3/13 15:11
 */
public interface CouponSampleThirdPartyService {

	/**
	 * 创建第三方券模板
	 *
	 * @param domain
	 * @param codes
	 * @return
	 */
	Boolean createCouponSampleThirdParty(CouponSampleThirdPartyEntity domain, List<String> codes);

	/**
	 * 编辑第三方券模板
	 *
	 * @param domain
	 * @return
	 */
	Boolean updateCouponSampleThirdParty(CouponSampleThirdPartyEntity domain,List<String> codes);

	/**
	 * 根据条件获取第三方券券列表
	 *
	 * @param condition
	 * @return
	 */
	List<CouponSampleThirdPartyEntity> getCouponSampleThirdPartysByCondition(CouponSampleThirdPartyCondition condition);

	CouponSampleThirdPartyEntity getCouponSampleThirdParty(Long id);

	/**
	 * 获取三方劵详情
	 * @param id
	 * @return
	 */
	CouponSampleThirdPartyEntity getCouponSampleThirdPartyDetails(Long id);

	/**
	 * 更新第三方券模板
	 *
	 * @param domain
	 * @return
	 */
	Boolean updateCouponSampleThirdParty(CouponSampleThirdPartyEntity domain);

}
