package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.dao.CouponCodeDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponCodeImpl;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeThirdPartyEntityExample;
import com.thebeastshop.pegasus.component.coupon.model.CouponThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponThirdPartyEntityExample;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeThirdPartyService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class CouponCodeThirdPartyServiceImpl extends BaseService implements CouponCodeThirdPartyService {

	@Autowired
	private CouponCodeThirdPartyEntityMapper couponCodeThirdPartyEntityMapper;
	@Autowired
	private CouponThirdPartyEntityMapper couponThirdPartyEntityMapper;
	
	@Override
	public CouponCodeThirdPartyEntity getValidByCode(String code,Long cstpId) {
		CouponCodeThirdPartyEntity obj = couponCodeThirdPartyEntityMapper.selectValidByCode(code,cstpId);
		return obj;
	}

	@Override
	 public List<CouponCodeThirdPartyEntity> getValidByCstpId(Long cstpId) {
		List<CouponCodeThirdPartyEntity> list = couponCodeThirdPartyEntityMapper.getValidByCstpId(cstpId);
		return list;
	}

	@Override
	public List<CouponCodeThirdPartyEntity> getCodeByCstpId(Long cstpId) {
		List<CouponCodeThirdPartyEntity> list = couponCodeThirdPartyEntityMapper.getCodeByCstpId(cstpId);
		return list;
	}

	@Override
	@Transactional
	public Boolean delCodesByCstpId(Long cstpId,List<String> codes) {
		//删除劵码
		CouponCodeThirdPartyEntityExample example = new CouponCodeThirdPartyEntityExample();
		CouponCodeThirdPartyEntityExample.Criteria criteria = example.createCriteria();
		criteria.andCodeIn(codes);
		criteria.andCstpIdEqualTo(cstpId);
		CouponCodeThirdPartyEntity couponCodeThirdPartyEntity = new CouponCodeThirdPartyEntity();
		couponCodeThirdPartyEntity.setActive(false);
		int count = couponCodeThirdPartyEntityMapper.updateByExampleSelective(couponCodeThirdPartyEntity,example);

		// 删除已领取的劵码
		CouponThirdPartyEntity couponThirdPartyEntity = new CouponThirdPartyEntity();
		couponThirdPartyEntity.setActive(false);
		CouponThirdPartyEntityExample example1 = new CouponThirdPartyEntityExample();
		CouponThirdPartyEntityExample.Criteria criteria1 = example1.createCriteria();
		criteria1.andCstpIdEqualTo(cstpId);
		criteria1.andCodeIn(codes);
		couponThirdPartyEntityMapper.updateByExampleSelective(couponThirdPartyEntity,example1);
		return true;
	}

}
