package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleThirdPartyCondition;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSampleThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleThirdPartyService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/3/13 15:15
 */
@Service
public class CouponSampleThirdPartyServiceImpl extends BaseService implements CouponSampleThirdPartyService {

	@Autowired
	private CouponSampleThirdPartyEntityMapper couponSampleThirdPartyEntityMapper;
	@Autowired
	private CouponCodeThirdPartyEntityMapper couponCodeThirdPartyEntityMapper;


	@Override
	@Transactional
	public Boolean createCouponSampleThirdParty(CouponSampleThirdPartyEntity domain,List<String> codes) {
		int id = couponSampleThirdPartyEntityMapper.insertSelective(domain);
		batchCouponCodes(domain,codes);
		return id > 0 ? true :false;
	}

	@Override
	@Transactional
	public Boolean updateCouponSampleThirdParty(CouponSampleThirdPartyEntity domain,List<String> codes) {
		CouponSampleThirdPartyEntity oldEntity = couponSampleThirdPartyEntityMapper.selectByPrimaryKey(domain.getId());
		if(CollectionUtils.isEmpty(codes)){
			domain.setBalanceCount(oldEntity.getBalanceCount());
			domain.setMaxCount(oldEntity.getMaxCount());
			domain.setCreateUserId(oldEntity.getCreateUserId());
		}else{
			batchCouponCodes(domain,codes);
			Integer addSize = codes.size();
			domain.setBalanceCount(oldEntity.getBalanceCount()+addSize);
			domain.setMaxCount(oldEntity.getMaxCount()+addSize);
			domain.setCreateUserId(oldEntity.getCreateUserId());
		}
		int count = couponSampleThirdPartyEntityMapper.updateByPrimaryKeySelective(domain);
		return count > 0 ? true :false;
	}

	@Override
	public List<CouponSampleThirdPartyEntity> getCouponSampleThirdPartysByCondition(CouponSampleThirdPartyCondition condition) {
		List<CouponSampleThirdPartyEntity> entityList = couponSampleThirdPartyEntityMapper.getCouponSampleThirdPartysByCondition(condition);
		return entityList;
	}


	private void batchCouponCodes(CouponSampleThirdPartyEntity domain,List<String> codes){
		if(CollectionUtils.isNotEmpty(codes)){
			for(String code :codes){
				CouponCodeThirdPartyEntity codeEntity = new CouponCodeThirdPartyEntity();
				codeEntity.setCode(code);
				codeEntity.setCstpId(domain.getId());
				codeEntity.setCreateUserId(domain.getCreateUserId());
				codeEntity.setCreateTime(new Date());
				codeEntity.setUpdateTime(new Date());
				codeEntity.setActive(true);
				codeEntity.setStatus(1);
				couponCodeThirdPartyEntityMapper.insertSelective(codeEntity);
			}
		}
	}

	@Override
	public CouponSampleThirdPartyEntity getCouponSampleThirdParty(Long id) {
		CouponSampleThirdPartyEntity couponSampleThirdPartyEntity = couponSampleThirdPartyEntityMapper.selectByPrimaryKey(id);
		return couponSampleThirdPartyEntity;
	}

	@Override
	public CouponSampleThirdPartyEntity getCouponSampleThirdPartyDetails(Long id) {
		CouponSampleThirdPartyEntity couponSampleThirdPartyEntity = couponSampleThirdPartyEntityMapper.selectByPrimaryKey(id);
		List<CouponCodeThirdPartyEntity> couponCodes = couponCodeThirdPartyEntityMapper.getCodeByCstpId(id);
		if(CollectionUtils.isNotEmpty(couponCodes)){
			List<String> codes = Lists.newArrayList();
			for(CouponCodeThirdPartyEntity couponCode :couponCodes ){
				codes.add(couponCode.getCode());
			}
			couponSampleThirdPartyEntity.setCodes(codes);
		}
		return couponSampleThirdPartyEntity;
	}

}
