package com.thebeastshop.pegasus.component.coupon.service;

import com.thebeastshop.pegasus.component.coupon.model.CouponCodeThirdPartyEntity;

import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/3/17 14:41 
 */
public interface CouponCodeThirdPartyService {
	/**
	 * 根据优惠口令获取有效优惠码
	 * 
	 * @param code
	 * @return
	 */
	CouponCodeThirdPartyEntity getValidByCode(String code,Long cstpId);

	/**
	 * 根据模板ID获取有效优惠码
	 *
	 * @param cstpId
	 * @return
	 */
	List<CouponCodeThirdPartyEntity> getValidByCstpId(Long cstpId);

	/**
	 * 根据模板id和优惠券码删除优惠券
	 * @param cstpId
	 * @param codes
	 * @return
	 */
	Boolean delCodesByCstpId(Long cstpId,List<String> codes);

}
