/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.condition.PendingCouponCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponSampleDao;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.CouponContent;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponCodeImpl;
import com.thebeastshop.pegasus.component.coupon.domain.impl.FullCutPrice;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.enums.CouponType;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.vo.NameValuePair;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponSampleServiceImpl
extends BaseService
implements CouponSampleService {
    @Autowired
    private CouponSampleDao couponSampleDao;
    @Autowired
    private CouponCodeService couponCodeService;

    private void validate(CouponSample obj) {
        if (obj.getCouponType() == null) {
            throw new WrongArgException("\u672a\u9009\u62e9\u4f18\u60e0\u5238\u7c7b\u578b", new NameValuePair[0]);
        }
        if (StringUtils.isEmpty((String)obj.getName())) {
            throw new WrongArgException("\u672a\u586b\u4f18\u60e0\u5238\u540d\u79f0", new NameValuePair[0]);
        }
        if (StringUtils.isEmpty((String)obj.getTitle())) {
            throw new WrongArgException("\u672a\u586b\u4f18\u60e0\u5238\u6807\u9898", new NameValuePair[0]);
        }
        if (obj.getBalanceCount() == null) {
            throw new WrongArgException("\u672a\u586b\u5269\u4f59\u6570\u91cf", new NameValuePair[0]);
        }
        if (obj.getMaxCount() == null) {
            throw new WrongArgException("\u672a\u586b\u751f\u6210\u6570\u91cf", new NameValuePair[0]);
        }
        if (obj.getMaxPerMember() == null) {
            throw new WrongArgException("\u672a\u586b\u7528\u6237\u9650\u9886\u6570\u91cf", new NameValuePair[0]);
        }
        if (CollectionUtils.isEmpty(obj.getAccessWays())) {
            throw new WrongArgException("\u672a\u9009\u62e9\u9002\u7528\u5e73\u53f0", new NameValuePair[0]);
        }
        if (obj.getCouponSendWay() == null) {
            throw new WrongArgException("\u672a\u9009\u62e9\u4f18\u60e0\u5238\u6d3e\u53d1\u65b9\u5f0f", new NameValuePair[0]);
        }
        if (obj.getStartTime() == null) {
            throw new WrongArgException("\u672a\u9009\u62e9\u4f18\u60e0\u5238\u5f00\u59cb\u65e5\u671f", new NameValuePair[0]);
        }
        if (obj.getExpireTime() == null) {
            throw new WrongArgException("\u672a\u9009\u62e9\u4f18\u60e0\u5238\u622a\u6b62\u65e5\u671f", new NameValuePair[0]);
        }
        if (!obj.getExpireTime().after(obj.getStartTime())) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5728\u5f00\u59cb\u65e5\u671f\u4e4b\u540e", new NameValuePair[0]);
        }
        if (obj.getCouponContent() == null) {
            throw new WrongArgException("\u672a\u586b\u4f18\u60e0\u5238\u4f18\u60e0\u5185\u5bb9", new NameValuePair[0]);
        }
        CouponContent content = obj.getCouponContent();
        if (obj.getCouponType().getId() == CouponType.CHEAPEN_LINE.getId()) {
            FullCutPrice fullCutPrice = (FullCutPrice)content;
            if (fullCutPrice.getFullPrice() == null) {
                throw new WrongArgException("\u672a\u586b\u4f18\u60e0\u6ee1\u8db3\u6761\u4ef6", new NameValuePair[0]);
            }
            if (fullCutPrice.getCutPrice() == null) {
                throw new WrongArgException("\u672a\u586b\u4f18\u60e0\u91d1\u989d", new NameValuePair[0]);
            }
            if (fullCutPrice.getFullPrice().compareTo(BigDecimal.ZERO) != 0 && fullCutPrice.getCutPrice().compareTo(fullCutPrice.getFullPrice()) > 0) {
                throw new WrongArgException("\u4f18\u60e0\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6ee1\u8db3\u6761\u4ef6", new NameValuePair[0]);
            }
        }
        if (obj.getCouponSendWay().getId() == CouponSendWay.CODE.getId()) {
            String code = obj.getCouponCode();
            if (StringUtils.isEmpty((String)code)) {
                throw new WrongArgException("\u4f18\u60e0\u53e3\u4ee4\u4e0d\u80fd\u4e3a\u7a7a", new NameValuePair[0]);
            }
            if (obj.getId() == null) {
                if (this.couponCodeService.isExistsSameCode(code)) {
                    throw new WrongArgException("\u5b58\u5728\u76f8\u540c\u4f18\u60e0\u53e3\u4ee4", new NameValuePair[0]);
                }
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("csid", obj.getId());
                map.put("code", code);
                if (this.couponCodeService.isExistsSameCodeByMap(map)) {
                    throw new WrongArgException("\u5b58\u5728\u76f8\u540c\u4f18\u60e0\u53e3\u4ee4", new NameValuePair[0]);
                }
            }
        }
    }

    @Override
    @Transactional
    public CouponSample create(CouponSample obj) {
        this.validate(obj);
        return this.couponSampleDao.create(obj);
    }

    private CouponCode buildCouponCode(CouponSample domain) {
        DefaultCouponCodeImpl couponCode = new DefaultCouponCodeImpl();
        couponCode.setCouponSampleId(domain.getId());
        couponCode.setCode(domain.getCouponCode());
        couponCode.setCreatorId(domain.getCreatorId());
        couponCode.setCreateTime(new Date());
        couponCode.setNote(domain.getNote());
        return couponCode;
    }

    @Override
    @Transactional
    public Boolean createCouponSample(CouponSample domain) {
        this.validate(domain);
        CouponSample couponSample = this.couponSampleDao.create(domain);
        if (null == couponSample || null == couponSample.getId()) {
            throw new BusinessLogicNotExpectedException("\u6dfb\u52a0\u4f18\u60e0\u6a21\u677f\u51fa\u9519");
        }
        if (domain.getCouponSendWay().getId().equals(CouponSendWay.CODE.getId())) {
            couponSample.setCouponCode(domain.getCouponCode());
            CouponCode couponCode = this.buildCouponCode(couponSample);
            if (domain.getId() == null) {
                CouponCode result = this.couponCodeService.create(couponCode);
                if (null == result || null == result.getId()) {
                    throw new BusinessLogicNotExpectedException("\u6dfb\u52a0\u4f18\u60e0\u7801\u51fa\u9519");
                }
            } else {
                Boolean flag = this.couponCodeService.update(couponCode);
                if (!flag.booleanValue()) {
                    throw new BusinessLogicNotExpectedException("\u7f16\u8f91\u4f18\u60e0\u7801\u51fa\u9519");
                }
            }
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateCouponSample(CouponSample domain) {
        CouponCode couponCode;
        boolean flag2;
        this.validate(domain);
        boolean flag = this.couponSampleDao.update(domain);
        if (!flag) {
            throw new BusinessLogicNotExpectedException("\u7f16\u8f91\u4f18\u60e0\u6a21\u677f\u51fa\u9519");
        }
        if (domain.getCouponSendWay().getId().equals(CouponSendWay.CODE.getId()) && !(flag2 = this.couponCodeService.update(couponCode = this.buildCouponCode(domain)))) {
            throw new BusinessLogicNotExpectedException("\u7f16\u8f91\u4f18\u60e0\u7801\u51fa\u9519");
        }
        return true;
    }

    @Override
    public boolean update(CouponSample obj) {
        return this.couponSampleDao.update(obj);
    }

    @Override
    public boolean decBalanceCount(CouponSample obj) {
        return this.couponSampleDao.decBalanceCount(obj);
    }

    @Override
    public boolean delete(Long id) {
        return false;
    }

    @Override
    public CouponSample getById(long id) {
        CouponSample obj = this.couponSampleDao.getById(id);
        if (obj == null) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728", "id", (Object)id);
        }
        return obj;
    }

    @Override
    public List<CouponSample> getByIds(List<Long> ids) {
        List<CouponSample> obj = this.couponSampleDao.getByIds(ids);
        if (obj == null) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728", "ids", ids);
        }
        return obj;
    }

    @Override
    public List<State> getStates() {
        return Lists.newArrayList((Object[])CouponSampleState.values());
    }

    @Override
    public List<CouponSendWay> getCouponSendWays() {
        return Arrays.asList(CouponSendWay.values());
    }

    @Override
    public List<AccessWay> getAccessWays() {
        return Arrays.asList(AccessWay.values());
    }

    @Override
    public List<CouponSample> getByCondition(CouponSampleCondition condition) {
        return this.couponSampleDao.getByCondition(condition);
    }

    @Override
    public List<CouponSample> getBySelectCondition(CouponSampleCondition condition) {
        return this.couponSampleDao.getBySelectCondition(condition);
    }

    @Override
    public List<CouponSample> getFirstPendingCouponSample(PendingCouponCondition cond) {
        Integer type = cond.getType();
        if (null == type) {
            return null;
        }
        if (1 == type) {
            return this.couponSampleDao.getFirstApprovaledCouponSample();
        }
        if (0 == type) {
            return this.couponSampleDao.getFirstPendingCouponSample();
        }
        return null;
    }

    @Override
    public List<CouponSample> getSecondPendingCouponSample(PendingCouponCondition cond) {
        Integer type = cond.getType();
        if (null == type) {
            return null;
        }
        if (1 == type) {
            return this.couponSampleDao.getSecondApprovaledCouponSample();
        }
        if (0 == type) {
            return this.couponSampleDao.getSecondPendingCouponSample();
        }
        return null;
    }

    @Override
    public Integer submitApproval(Long id) {
        return this.couponSampleDao.submitApproval(id);
    }

    @Override
    public CouponSample checkById(long id) {
        CouponSample one = this.getById(id);
        if (one == null) {
            throw new NoSuchResourceException("\u4f18\u60e0\u5238\u6837\u677f", (Object)id);
        }
        return one;
    }
}

