package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleThirdPartyCondition;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSampleThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleThirdPartyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/3/13 15:15
 */
@Service
public class CouponSampleThirdPartyServiceImpl extends BaseService implements CouponSampleThirdPartyService {

	@Autowired
	private CouponSampleThirdPartyEntityMapper couponSampleThirdPartyEntityMapper;

	@Override
	public Boolean createCouponSampleThirdParty(CouponSampleThirdPartyEntity domain) {
		int id = couponSampleThirdPartyEntityMapper.insertSelective(domain);
		return id > 0 ? true :false;
	}

	@Override
	public Boolean updateCouponSampleThirdParty(CouponSampleThirdPartyEntity domain) {
		int count = couponSampleThirdPartyEntityMapper.updateByPrimaryKeySelective(domain);
		return count > 0 ? true :false;
	}

	@Override
	public List<CouponSampleThirdPartyEntity> getCouponSampleThirdPartysByCondition(CouponSampleThirdPartyCondition condition) {
		List<CouponSampleThirdPartyEntity> entityList = couponSampleThirdPartyEntityMapper.getCouponSampleThirdPartysByCondition(condition);
		return entityList;
	}

}
