/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponSampleDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSampleEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.CouponContent;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponSampleImpl;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.enums.CouponType;
import com.thebeastshop.pegasus.component.coupon.enums.ProductScope;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleEntityExample;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.WrongEntityException;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.NameValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponSampleDaoImpl
implements CouponSampleDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CouponSampleEntityMapper mapper;

    private CouponSampleEntity domain2Entity(CouponSample obj) {
        CouponSampleEntity entity = null;
        try {
            if (obj != null) {
                entity = new CouponSampleEntity();
                if (CollectionUtils.isNotEmpty(obj.getAccessWays())) {
                    StringBuilder strAccessWays = new StringBuilder();
                    strAccessWays.append(",");
                    for (AccessWay aw : obj.getAccessWays()) {
                        strAccessWays.append(aw.getId()).append(",");
                    }
                    entity.setAccessWays(strAccessWays.toString());
                }
                entity.setBalanceCount(obj.getBalanceCount());
                CouponContent couponContent = obj.getCouponContent();
                if (couponContent != null) {
                    entity.setCouponContent(JsonUtil.toJson((Object)couponContent));
                }
                if (obj.getCouponSendWay() != null) {
                    entity.setCouponSendWay(obj.getCouponSendWay().getId());
                }
                if (obj.getCouponType() != null) {
                    entity.setCouponType(obj.getCouponType().getId());
                }
                entity.setCreateTime(obj.getCreateTime());
                entity.setCreatorId(obj.getCreatorId());
                entity.setDescription(obj.getDescription());
                entity.setExpireTime(obj.getExpireTime());
                entity.setId(obj.getId());
                entity.setMaxCount(obj.getMaxCount());
                entity.setMaxPerMember(obj.getMaxPerMember());
                entity.setName(obj.getName());
                entity.setTitle(obj.getTitle());
                entity.setNote(obj.getNote());
                entity.setProductDesc(obj.getProductDesc());
                entity.setDateWay(obj.getDateWay());
                entity.setDateNum(obj.getDateNum());
                entity.setCrossBorder(obj.getCrossBorder());
                entity.setWeekFlower(obj.getWeekFlower());
                if (CollectionUtils.isNotEmpty(obj.getCategoryIds())) {
                    entity.setCategoryIds("," + StringUtils.join(obj.getCategoryIds(), (String)",") + ",");
                }
                if (null != obj.getProductScope()) {
                    entity.setProductScope(obj.getProductScope().getId());
                }
                if (CollectionUtils.isNotEmpty(obj.getProductIds())) {
                    entity.setProductIds("," + StringUtils.join(obj.getProductIds(), (String)",") + ",");
                }
                if (CollectionUtils.isNotEmpty(obj.getExcludeProductIds())) {
                    entity.setExcludeProductIds("," + StringUtils.join(obj.getExcludeProductIds(), (String)",") + ",");
                }
                entity.setStartTime(obj.getStartTime());
                entity.setStateId(obj.getStateId());
            }
        }
        catch (Exception e) {
            throw new WrongEntityException(this.getClass().getSimpleName() + "\u65b9\u6cd5domain2Entity\u7684\u5f02\u5e38: " + e.getMessage(), new NameValuePair[0]);
        }
        return entity;
    }

    private CouponSample entity2Domain(CouponSampleEntity entity) {
        DefaultCouponSampleImpl obj = null;
        try {
            if (entity != null) {
                String categoryIds;
                String exProdStrIds;
                String prodStrIds;
                obj = new DefaultCouponSampleImpl();
                if (StringUtils.isNotBlank((String)entity.getAccessWays())) {
                    ArrayList accessWays = Lists.newArrayList();
                    List<String> list = Arrays.asList(entity.getAccessWays().split(","));
                    for (String str : list) {
                        if (!StringUtils.isNotEmpty((String)str)) continue;
                        accessWays.add(AccessWay.valueOf((int)Integer.parseInt(str)));
                    }
                    obj.setAccessWays(accessWays);
                }
                if (StringUtils.isNotEmpty((String)(prodStrIds = entity.getProductIds()))) {
                    ArrayList prodIds = Lists.newArrayList();
                    List<String> list = Arrays.asList(prodStrIds.split(","));
                    for (String str : list) {
                        if (!StringUtils.isNotEmpty((String)str)) continue;
                        try {
                            prodIds.add(Long.parseLong(str));
                        }
                        catch (Exception ex) {}
                    }
                    obj.setProductIds(prodIds);
                }
                if (StringUtils.isNotEmpty((String)(exProdStrIds = entity.getExcludeProductIds()))) {
                    ArrayList exProdIds = Lists.newArrayList();
                    List<String> list = Arrays.asList(exProdStrIds.split(","));
                    for (String str : list) {
                        if (!StringUtils.isNotEmpty((String)str)) continue;
                        try {
                            exProdIds.add(Long.parseLong(str));
                        }
                        catch (Exception ex) {}
                    }
                    obj.setExcludeProductIds(exProdIds);
                }
                if (StringUtils.isNotEmpty((String)(categoryIds = entity.getCategoryIds()))) {
                    ArrayList categoryIdsList = Lists.newArrayList();
                    List<String> list = Arrays.asList(categoryIds.split(","));
                    for (String str : list) {
                        if (!StringUtils.isNotEmpty((String)str)) continue;
                        try {
                            categoryIdsList.add(Long.parseLong(str));
                        }
                        catch (Exception ex) {}
                    }
                    obj.setCategoryIds(categoryIdsList);
                }
                obj.setBalanceCount(entity.getBalanceCount());
                obj.setCouponContent(entity.getCouponContent());
                obj.setCouponSendWay(CouponSendWay.valueOf(entity.getCouponSendWay()));
                obj.setCouponType(CouponType.valueOf(entity.getCouponType()));
                obj.setCreateTime(entity.getCreateTime());
                obj.setCreatorId(entity.getCreatorId());
                obj.setDescription(entity.getDescription());
                obj.setExpireTime(entity.getExpireTime());
                obj.setId(entity.getId());
                obj.setMaxCount(entity.getMaxCount());
                obj.setMaxPerMember(entity.getMaxPerMember());
                obj.setName(entity.getName());
                obj.setTitle(entity.getTitle());
                obj.setNote(entity.getNote());
                obj.setProductDesc(entity.getProductDesc());
                obj.setDateWay(entity.getDateWay());
                obj.setDateNum(entity.getDateNum());
                obj.setCrossBorder(entity.getCrossBorder());
                obj.setWeekFlower(entity.getWeekFlower());
                if (null != entity.getProductScope()) {
                    obj.setProductScope((ProductScope)EnumUtil.valueOf((Comparable)entity.getProductScope(), ProductScope.class));
                }
                if (entity.getProductIds() != null) {
                    obj.setProductIds(this.parseIds(entity.getProductIds()));
                }
                obj.setStartTime(entity.getStartTime());
                obj.setStateId(entity.getStateId());
                if (entity.getCouponCode() != null) {
                    obj.setCouponCode(entity.getCouponCode());
                }
                obj.setNickName(entity.getNickName());
            }
        }
        catch (Exception e) {
            throw new WrongEntityException(this.getClass().getSimpleName() + "\u65b9\u6cd5entity2Domain\u7684\u5f02\u5e38: " + e.getMessage(), new NameValuePair[0]);
        }
        return obj;
    }

    private List<Long> parseIds(String strIds) {
        String[] strIdArr;
        if (StringUtils.isEmpty((String)strIds)) {
            return Lists.newArrayList();
        }
        ArrayList results = Lists.newArrayList();
        for (String strId : strIdArr = strIds.split(",")) {
            if (!StringUtils.isNotEmpty((String)strId)) continue;
            try {
                results.add(Long.valueOf(strId));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return results;
    }

    private List<CouponSample> entity2Domain(List<CouponSampleEntity> entities) {
        ArrayList domains = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (CouponSampleEntity entity : entities) {
                domains.add(this.entity2Domain(entity));
            }
        }
        return domains;
    }

    @Override
    public CouponSample create(CouponSample obj) {
        this.logger.info("Creating CouponSample: {}", (Object)obj);
        CouponSampleEntity entity = this.domain2Entity(obj);
        if (entity != null) {
            entity.setCreateTime(new Date());
            int count = this.mapper.insertSelective(entity);
            if (count > 0) {
                obj = this.entity2Domain(entity);
                this.logger.info("Created CouponSample: {}", (Object)obj);
                return obj;
            }
        }
        return null;
    }

    @Override
    public boolean update(CouponSample obj) {
        int count;
        this.logger.info("Updating CouponSample: {}", (Object)obj);
        CouponSampleEntity entity = this.domain2Entity(obj);
        if (entity != null && (count = this.mapper.updateByPrimaryKeySelective(entity)) > 0) {
            this.logger.info("Updated CouponSample: {}", (Object)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean decBalanceCount(CouponSample obj) {
        int count;
        CouponSampleEntity entity = this.domain2Entity(obj);
        if (entity != null && (count = this.mapper.decBalanceCount(entity)) > 0) {
            this.logger.info("Updated CouponSample: {}", (Object)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(Long id) {
        return false;
    }

    @Override
    public CouponSample getById(long id) {
        return this.entity2Domain(this.mapper.selectByPrimaryKey(id));
    }

    @Override
    public List<State> getStates() {
        return Lists.newArrayList((Object[])CouponSampleState.values());
    }

    @Override
    public List<CouponSendWay> getCouponSendWays() {
        return Arrays.asList(CouponSendWay.values());
    }

    @Override
    public List<AccessWay> getAccessWays() {
        return Arrays.asList(AccessWay.values());
    }

    @Override
    public List<CouponSample> getByCondition(CouponSampleCondition condition) {
        CouponSampleEntityExample example = new CouponSampleEntityExample();
        condition.fillCriteria(example.createCriteria());
        example.setOrderByClause("create_time DESC");
        List<CouponSampleEntity> entityList = this.mapper.selectByExample(example);
        return this.entity2Domain(entityList);
    }

    @Override
    public List<CouponSample> getBySelectCondition(CouponSampleCondition condition) {
        List<CouponSampleEntity> entityList = this.mapper.selectByCondition(condition);
        return this.entity2Domain(entityList);
    }

    @Override
    public List<CouponSample> getFirstPendingCouponSample() {
        return this.entity2Domain(this.mapper.getFirstPendingCouponSample());
    }

    @Override
    public List<CouponSample> getSecondPendingCouponSample() {
        return this.entity2Domain(this.mapper.getSecondPendingCouponSample());
    }

    @Override
    public List<CouponSample> getFirstApprovaledCouponSample() {
        return this.entity2Domain(this.mapper.getApprovaledCouponSample(1));
    }

    @Override
    public List<CouponSample> getSecondApprovaledCouponSample() {
        return this.entity2Domain(this.mapper.getApprovaledCouponSample(2));
    }

    @Override
    public Integer changeCouponSampleState(Long id, Integer state) {
        CouponSampleEntity entity = new CouponSampleEntity();
        entity.setId(id);
        entity.setStateId(state);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public Integer submitApproval(Long id) {
        CouponSampleEntity entity = new CouponSampleEntity();
        entity.setId(id);
        entity.setStateId(1);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public CouponSample checkById(long id) {
        CouponSample one = this.getById(id);
        if (one == null) {
            throw new NoSuchResourceException("\u4f18\u60e0\u5238\u6837\u677f", (Object)id);
        }
        return one;
    }
}

