package com.thebeastshop.pegasus.component.coupon.domain.impl;

import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;
import com.thebeastshop.pegasus.component.coupon.enums.ApprovalType;
import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalLevel;
import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalResult;

import java.util.Date;

/**
 * Created by hafiz.zhang on 2016/7/6.
 */
public class DefaultApprovalRecordImpl implements ApprovalRecord {

    private Long id;                                        //审批记录编号
    private Long pendingId;                                 //待审批项目(活动或者优惠券)编号
    private String pendingCode;                             //待审批编码
    private Integer campaignState;                          //待审批活动的上下线状态
    private Long creatorId;                                 //审批人编号
    private ApprovalType type;                              //审批记录类型 1.优惠券审批记录  2.活动审批记录
    private String nickName;                                //审批人昵称
    private CouponApprovalLevel couponApprovalLevel;        //审批级别： 1.第一级审批  2.第二级审批
    private CouponApprovalResult couponApprovalResult;      //审批结果： 1.同意  0.驳回
    private String opinion;                                 //审批意见
    private Date createTime;                                //审批时间

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public Long getPendingId() {
        return pendingId;
    }

    @Override
    public String getPendingCode() {
        return pendingCode;
    }

    public void setPendingCode(String pendingCode) {
        this.pendingCode = pendingCode;
    }

    @Override
    public Integer getType() {
        if(null == type) {
            return null;
        }
        return type.getId();
    }

    @Override
    public Long getCreatorId() {
        return creatorId;
    }

    @Override
    public CouponApprovalLevel getCouponApprovalLevel() {
        return couponApprovalLevel;
    }

    @Override
    public CouponApprovalResult getCouponApprovalResult() {
        return couponApprovalResult;
    }

    @Override
    public String getOpinion() {
        return opinion;
    }

    @Override
    public String getNickName() {
        return nickName;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    public void setType(ApprovalType type) {this.type = type;}

    public void setId(Long id) {
        this.id = id;
    }

    public void setPendingId(Long pendingId) {
        this.pendingId = pendingId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setCouponApprovalLevel(CouponApprovalLevel couponApprovalLevel) {
        this.couponApprovalLevel = couponApprovalLevel;
    }

    public void setCouponApprovalResult(CouponApprovalResult couponApprovalResult) {
        this.couponApprovalResult = couponApprovalResult;
    }

    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    @Override
    public Integer getCampaignState() {
        return campaignState;
    }

    public void setCampaignState(Integer campaignState) {
        this.campaignState = campaignState;
    }
}
