package com.thebeastshop.pegasus.component.coupon.service;

import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSetCondition;
import com.thebeastshop.pegasus.component.coupon.condition.PendingCouponCondition;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.model.CouponSetEntity;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.mark.State;

import java.util.Collection;
import java.util.List;

/**
 * @author Liang Wenjian
 */
public interface CouponSetService {

	/**
	 * 创建套券模板
	 *
	 * @param domain
	 *
	 * @return
	 */
	Boolean createCouponSet(CouponSetEntity domain);/**
	 * 编辑套券模板
	 *
	 * @param domain
	 *
	 * @return
	 */
	Boolean updateCouponSet(CouponSetEntity domain);

	/**
	 * 根据条件获取套券列表
	 *
	 * @param condition
	 * @return
	 */
	List<CouponSetEntity> getCouponSetsByCondition(CouponSetCondition condition);

	/**
	 * 根据套券IDS获取优惠券ID列表
	 *
	 * @param condition
	 * @return
	 */
	List<Long> getCouponSampleIdsByCondition(CouponSetCondition condition);

}
