package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.dao.ApprovalRecordDao;
import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;
import com.thebeastshop.pegasus.component.coupon.service.ApprovalRecordService;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Desc:审批记录操作相关的service接口实现
 *
 * Created by hafiz.zhang on 2016/7/13.
 */
@Service
public class ApprovalRecordServiceImpl extends BaseService implements ApprovalRecordService {

    @Autowired
    private ApprovalRecordDao approvalRecordDao;

    @Override
    public ApprovalRecord create(ApprovalRecord domain) {
        return approvalRecordDao.create(domain);
    }

    @Override
    public List<ApprovalRecord> listApprovalRecordByPendingId(Long pendingId, Integer type) {
        return approvalRecordDao.getApprovalByPendingId(pendingId, type);
    }
}
