package com.thebeastshop.pegasus.component.coupon.domain.impl;

import java.math.BigDecimal;
import java.util.Collection;

import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;

/**
 * 满减优惠券
 * 
 * @author Paul-xiong
 *
 */
public class FullCutCouponImpl extends CouponWrapper<Coupon> {

	private final CouponSample couponSample;

	private final FullCutPrice fullCutPrice;

	public FullCutCouponImpl(final Coupon e, final CouponSample couponSample) {
		super(e);
		this.couponSample = couponSample;
		this.fullCutPrice = (FullCutPrice) couponSample.getCouponContent();
	}

	/**
	 * 满足金额描述
	 * 
	 * @return
	 */
	public String getFullPriceDesc() {
		if (fullCutPrice != null) {
			return fullCutPrice.getDescription();
		}
		return "";
	}

	/**
	 * 满足金额
	 * 
	 * @return
	 */
	public BigDecimal getFullPrice() {
		return fullCutPrice.getFullPrice();
	}

	/**
	 * 减去金额
	 * 
	 * @return
	 */
	public BigDecimal getCutPrice() {
		return fullCutPrice.getCutPrice();
	}

	public String getProductDesc() {
		return couponSample.getProductDesc();
	}

	public String getDescription() {
		return couponSample.getDescription();
	}

	public Collection<Long> getProductIds() {
		return couponSample.getProductIds();
	}

	public String getTitle() {
		return couponSample.getName();
	}

}
