package com.thebeastshop.pegasus.component.coupon.domain;

import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalLevel;
import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalResult;
import com.thebeastshop.support.mark.HasCreateTime;
import com.thebeastshop.support.mark.HasCreatorId;
import com.thebeastshop.support.mark.HasIdGetter.HasLongIdGetter;

/**
 * Created by hafiz.zhang on 2016/7/6.
 */
public interface ApprovalRecord extends HasLongIdGetter, HasCreatorId, HasCreateTime{
    /**
     * 获取待审批项目编号
     *
     * @return
     */
    Long getPendingId();

    /**
     * 获取待审批项目编码
     *
     * @return
     */
    String getPendingCode();

    /**
     * 获取活动上下线状态
     *
     * @return
     */
    Integer getCampaignState();

    /**
     * 获取审批记录类型 1.优惠券审批记录  2.活动审批记录
     *
     * @return
     */
    Integer getType();

    /**
     * 获取审批级别
     *
     * @return
     */
    CouponApprovalLevel getCouponApprovalLevel();

    /**
     * 获取审批结果
     *
     * @return
     */
    CouponApprovalResult getCouponApprovalResult();

    /**
     * 获取审批意见
     *
     * @return
     */
    String getOpinion();

    /**
     * 获取审批人昵称
     *
     * @return
     */
    String getNickName();

}
