package com.thebeastshop.pegasus.component.coupon.service;

import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;

import java.util.List;

/**
 * Desc:优惠券审核相关的service操作接口
 * Created by hafiz.zhang on 2016/7/7.
 */
public interface CouponApprovalService {
    /**
     * 创建优惠券审核记录
     *
     * @param domain    待创建的优惠券记录domain
     *
     * @return  创建成功的优惠券记录
     */
    ApprovalRecord create(ApprovalRecord domain);

    /**
     * 根据待审批项目编号获取审批记录
     *
     * @return
     */
    List<ApprovalRecord> getApprovalByPendingId(Long pendingId);

    /**
     * 同意优惠券审批
     *
     * @param domain   审批实体
     *
     * @return
     */
    Boolean agreePendingCouponSample(ApprovalRecord domain);

    /**
     * 驳回优惠券审批
     *
     * @param domain    审批实体
     *
     * @return
     */
    Boolean rejectPendingCouponSample(ApprovalRecord domain);
}
