package com.thebeastshop.pegasus.component.coupon.domain.impl;

import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;

import java.util.Date;

/**
 * @author Liang Wenjian
 */
public class DefaultCouponImpl extends CouponTemplate {

	private Long id;

	private Long couponSampleId;

	private Long ownerId;

	private boolean isUsed;

	private boolean isValid;

	private String note;

	private Date startTime;

	private Date expireTime;

	private Date createTime;

	private CouponSample couponSample;

	private String nickName;

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	@Override
	public Long getCouponSampleId() {
		return couponSampleId;
	}

	@Override
	public boolean isUsed() {
		return isUsed;
	}

	@Override
	public String getNote() {
		return note;
	}

	@Override
	public boolean isValid() {
		return isValid;
	}

	@Override
	public Long getOwnerId() {
		return ownerId;
	}

	@Override
	public Long getId() {
		return id;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	@Override
	public Date getExpireTime() {
		return expireTime;
	}

	@Override
	public Date getStartTime() {
		return startTime;
	}

	public void setCouponSampleId(Long couponSampleId) {
		this.couponSampleId = couponSampleId;
	}

	public void setUsed(boolean isUsed) {
		this.isUsed = isUsed;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public void setValid(boolean isValid) {
		this.isValid = isValid;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public void setExpireTime(Date expireTime) {
		this.expireTime = expireTime;
	}

	public void setNote(String note) {
		this.note = note;
	}

	@Override
	public boolean isAvailable() {
		return !isUsed() && isValid() && !isExpired();
	}

	@Override
	public boolean isExpired() {
		return expireTime.before(new Date());
	}

	@Override
	public CouponSample getCouponSample() {
		return couponSample;
	}

	public void setCouponSample(CouponSample couponSample) {
		this.couponSample = couponSample;
	}
}
