package com.thebeastshop.pegasus.component.coupon.service;

import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;

import java.util.List;

/**
 * Desc:审批记录操作相关的service接口
 *
 * Created by hafiz.zhang on 2016/7/13.
 */
public interface ApprovalRecordService {
    /**
     * 创建审批记录
     *
     * @param domain    带创建的审批记录
     *
     * @return
     */
    ApprovalRecord create(ApprovalRecord domain);

    /**
     * 根据pendingId获取所有审批记录
     *
     * @param pendingId 待审批项目id
     *
     * @param type      审批类型
     *
     * @return
     */
    List<ApprovalRecord> listApprovalRecordByPendingId(Long pendingId, Integer type);
}
