package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 优惠类型
 * 
 * @author Paul-xiong
 *
 */
public enum CouponType implements HasIntIdGetter, HasName {
	CHEAPEN_LINE(1, "满减"),
	DISCOUNT(2,"折扣")
	;

	private final int id;

	private final String name;

	public static final List<CouponType> ALL = Collections.unmodifiableList(Arrays.asList(values()));


	private CouponType(int id, String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public Integer getId() {
		return id;
	}
	
	public static CouponType valueOf(int id) {
		CouponType value = CHEAPEN_LINE;
		if (id == CHEAPEN_LINE.id) {
			value = CHEAPEN_LINE;
		} else if(id == DISCOUNT.id){
			value = DISCOUNT;
		}
		return value;
	}

}
