package com.thebeastshop.pegasus.component.coupon.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponImpl;
import com.thebeastshop.support.mark.HasCreateTime;
import com.thebeastshop.support.mark.HasIdGetter.HasLongIdGetter;
import com.thebeastshop.support.mark.HasNote;
import com.thebeastshop.support.mark.HasOwner;
import com.thebeastshop.support.mark.Validatable;
import com.thebeastshop.support.mark.WillExpire;

/**
 * @author Liang Wenjian
 */
@JsonDeserialize(as = DefaultCouponImpl.class)
public interface Coupon extends HasLongIdGetter, HasOwner, HasCreateTime, Validatable, WillExpire, HasNote {

	/**
	 * 生成本优惠券的优惠券样板id。
	 *
	 * @return 若不是通过优惠券样板生成的，则为null
	 */
	Long getCouponSampleId();

	/**
	 * 是否已被使用
	 *
	 * @return
	 */
	boolean isUsed();

	/**
	 * 是否可用的
	 *
	 * @return
	 */
	boolean isAvailable();

	CouponSample getCouponSample();

	String getNickName();
}
