/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.dao.ApprovalRecordDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.ApprovalRecordEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultApprovalRecordImpl;
import com.thebeastshop.pegasus.component.coupon.enums.ApprovalType;
import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalLevel;
import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalResult;
import com.thebeastshop.pegasus.component.coupon.model.ApprovalRecordEntity;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ApprovalRecordDaoImpl
implements ApprovalRecordDao {
    private Logger logger = LoggerFactory.getLogger(ApprovalRecordDaoImpl.class);
    @Autowired
    private ApprovalRecordEntityMapper mapper;

    private ApprovalRecordEntity domain2Entity(ApprovalRecord domain) {
        ApprovalRecordEntity entity = new ApprovalRecordEntity();
        entity.setId(domain.getId());
        entity.setApproverId(domain.getCreatorId());
        entity.setType(domain.getType());
        entity.setNickName(domain.getNickName());
        entity.setPendingId(domain.getPendingId());
        entity.setOpinion(domain.getOpinion());
        if (null != domain.getCouponApprovalLevel()) {
            entity.setLevel(domain.getCouponApprovalLevel().getId());
        }
        if (null != domain.getCouponApprovalResult()) {
            entity.setResult(domain.getCouponApprovalResult().getId());
        }
        entity.setCreateTime(domain.getCreateTime());
        return entity;
    }

    private ApprovalRecord entity2Domain(ApprovalRecordEntity entity) {
        if (null == entity) {
            return null;
        }
        DefaultApprovalRecordImpl domain = new DefaultApprovalRecordImpl();
        domain.setId(entity.getId());
        domain.setNickName(entity.getNickName());
        domain.setCreatorId(entity.getApproverId());
        domain.setPendingId(entity.getPendingId());
        domain.setType((ApprovalType)EnumUtil.valueOf((Comparable)entity.getType(), ApprovalType.class));
        domain.setCouponApprovalLevel((CouponApprovalLevel)EnumUtil.valueOf((Comparable)entity.getLevel(), CouponApprovalLevel.class));
        domain.setCouponApprovalResult((CouponApprovalResult)EnumUtil.valueOf((Comparable)entity.getResult(), CouponApprovalResult.class));
        domain.setOpinion(entity.getOpinion());
        domain.setCreateTime(entity.getCreateTime());
        return domain;
    }

    private List<ApprovalRecord> entity2Domain(List<ApprovalRecordEntity> entities) {
        if (null == entities) {
            return null;
        }
        ArrayList domains = Lists.newArrayList();
        for (ApprovalRecordEntity entity : entities) {
            domains.add(this.entity2Domain(entity));
        }
        return domains;
    }

    @Override
    public ApprovalRecord create(ApprovalRecord couponApproval) {
        this.logger.info("Creating CouponApproval: {}" + couponApproval);
        ApprovalRecordEntity entity = this.domain2Entity(couponApproval);
        if (null != entity) {
            entity.setCreateTime(new Date());
            Integer count = this.mapper.insertSelective(entity);
            if (count > 0) {
                couponApproval = this.entity2Domain(entity);
                this.logger.info("Created CouponApproval: {}" + couponApproval);
                return couponApproval;
            }
        }
        return null;
    }

    @Override
    public List<ApprovalRecord> getApprovalByPendingId(Long pendingId, Integer type) {
        return this.entity2Domain(this.mapper.getApprovalByPendingId(pendingId, type));
    }
}

