package com.thebeastshop.pegasus.component.coupon.domain.impl;

import com.thebeastshop.pegasus.component.coupon.domain.CouponContent;

import java.math.BigDecimal;

/**
 * 满减金额
 * 
 * @author Paul-xiong
 *
 */
public class FullCutPrice implements CouponContent {
	/**
	 * 满足金额
	 */
	public BigDecimal fullPrice;
	/**
	 * 减去金额
	 */
	public BigDecimal cutPrice;

	public FullCutPrice() {
		super();
	}

	public FullCutPrice(BigDecimal fullPrice, BigDecimal cutPrice) {
		super();
		this.fullPrice = fullPrice;
		this.cutPrice = cutPrice;
	}

	public BigDecimal getFullPrice() {
		return fullPrice;
	}

	public void setFullPrice(BigDecimal fullPrice) {
		this.fullPrice = fullPrice;
	}

	public BigDecimal getCutPrice() {
		return cutPrice;
	}

	public void setCutPrice(BigDecimal cutPrice) {
		this.cutPrice = cutPrice;
	}

	@Override
	public String toString() {
		return "FullCutPrice [fullPrice=" + fullPrice + ", cutPrice=" + cutPrice + "]";
	}

	@Override
	public String getDescription() {
		StringBuilder sb = new StringBuilder();
		if(getFullPrice().compareTo(BigDecimal.ZERO) == 0) {
			return sb.append("无门槛").toString();
		}else {
			return sb.append("满").append(getFullPrice()).append("可用").toString();
		}
	}
}