package com.thebeastshop.pegasus.component.coupon.util;

/**
 * Created by Administrator on 2016/8/22.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Properties;

public class ConnectionFactory {
    private static String url;
    private static String driver;
    private static String user;
    private static String password;

    static {
        try {
            Properties props = new Properties();

            props.load(ConnectionFactory.class.getClassLoader()
                    .getResourceAsStream("coupon/jdbc.properties")); //得到当前类的类加载器,以流的方式读取配置文件

            driver = props.getProperty("jdbc.driverClassName");
            url = props.getProperty("jdbc.url");
            user = props.getProperty("jdbc.username");
            password = props.getProperty("jdbc.password");

            Class.forName(driver); //加载驱动程序

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    //返回Connection
    public static Connection getConnection() throws Exception {
        try {
            Connection con = DriverManager.getConnection(url, user, password);
            return con;
        } catch (Exception e) {
            return null;
        }
    }

}
