package com.thebeastshop.pegasus.component.coupon.domain;

import com.thebeastshop.support.mark.HasCreateTime;
import com.thebeastshop.support.mark.HasOwner;

import java.util.Date;
import java.util.Objects;

/**
 * @author Liang Wenjian
 */
public class CouponCodeExchange implements HasCreateTime, HasOwner {

	private Long id;
	private Long couponSampleId;
	private Long couponId;
	private Long ownerId;
	private String code;
	private Date createTime;

	public Long getId() {
		return id;
	}

	public void setId(final Long id) {
		this.id = id;
	}

	public Long getCouponSampleId() {
		return couponSampleId;
	}

	public void setCouponSampleId(Long couponSampleId) {
		this.couponSampleId = couponSampleId;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	@Override
	public Long getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(final Long ownerId) {
		this.ownerId = ownerId;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(final Date createTime) {
		this.createTime = createTime;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof CouponCodeExchange)) {
			return false;
		}
		final CouponCodeExchange that = (CouponCodeExchange) o;
		return Objects.equals(getId(), that.getId());
	}

	@Override
	public int hashCode() {
		return Objects.hash(getId());
	}

	@Override
	public String toString() {
		return "CouponCodeExchange [id=" + id + ", couponSampleId=" + couponSampleId + ", couponId=" + couponId
				+ ", ownerId=" + ownerId + ", code=" + code + ", createTime=" + createTime + "]";
	}

}
