package com.thebeastshop.pegasus.component.coupon.service;

import java.util.List;

import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.condition.PendingCouponCondition;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.mark.State;

/**
 * @author Liang Wenjian
 */
public interface CouponSampleService {

	CouponSample create(CouponSample obj);

	/**
	 * 创建优惠券模板
	 *
	 * @param domain
	 *
	 * @return
	 */
	Boolean createCouponSample(CouponSample domain);/**
	 * 编辑优惠券模板
	 *
	 * @param domain
	 *
	 * @return
	 */
	Boolean updateCouponSample(CouponSample domain);

	boolean update(CouponSample obj);

	boolean decBalanceCount(CouponSample obj);

	boolean delete(Long id);

	CouponSample getById(long id);

	CouponSample checkById(final long id);

	/**
	 * 获取优惠券样板所有的可能的状态。
	 *
	 * @return
	 */
	List<State> getStates();

	/**
	 *
	 * @return
	 */
	List<CouponSendWay> getCouponSendWays();

	List<AccessWay> getAccessWays();

	/**
	 * 根据条件获取优惠券模板列表
	 * 
	 * @param condition
	 * @return
	 */
	List<CouponSample> getByCondition(final CouponSampleCondition condition);

	List<CouponSample> getBySelectCondition(CouponSampleCondition condition);

	/**
	 * 获取待进行第一级审核的优惠券模板列表
	 *
	 * @return
	 */
	List<CouponSample> getFirstPendingCouponSample(final PendingCouponCondition cond);

	/**
	 * 获取待进行第二级审核的优惠券模板列表
	 *
	 * @return
	 */
	List<CouponSample> getSecondPendingCouponSample(final PendingCouponCondition cond);

	/**
	 * 提交审批草稿优惠券
	 *
	 * @param id
	 *
	 * @return
	 */
	Integer submitApproval(Long id);
}
