/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponDao;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCount;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.CouponWrapper;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponImpl;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponSampleImpl;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.pegasus.component.coupon.service.CouponService;
import com.thebeastshop.pegasus.component.coupon.util.ConnectionFactory;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongStateException;
import com.thebeastshop.support.vo.NameValuePair;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponServiceImpl
extends BaseService
implements CouponService {
    @Autowired
    private CouponSampleService couponSampleService;
    @Autowired
    private CouponDao couponDao;

    @Override
    public Coupon getById(long id) {
        Coupon obj = this.couponDao.getById(id);
        if (obj == null) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728", "id", (Object)id);
        }
        return obj;
    }

    @Override
    public List<Coupon> getCoupons(long ownerId) {
        return this.couponDao.getCoupons(ownerId);
    }

    @Override
    public List<Coupon> getCoupons(long ownerId, Long couponSampleId) {
        return this.couponDao.getCoupons(ownerId, couponSampleId);
    }

    @Override
    public List<Coupon> getUsableCoupons(long ownerId) {
        return this.couponDao.getUsableCoupons(ownerId);
    }

    @Override
    public List<Coupon> getExpiredCoupons(long ownerId) {
        return this.couponDao.getExpiredCoupons(ownerId);
    }

    @Override
    public List<Coupon> getUsedCoupons(long ownerId) {
        return this.couponDao.getUsedCoupons(ownerId);
    }

    @Override
    public List<Coupon> getCouponsByCondition(CouponCondition condition) {
        return this.couponDao.getCouponsByCondition(condition);
    }

    @Override
    public CouponCount queryCouponCount(CouponCondition condition) {
        return this.couponDao.countCouponByCondition(condition);
    }

    @Override
    public Coupon create(Coupon coupon) {
        return this.couponDao.create(coupon);
    }

    @Override
    public void invalid(Coupon coupon) {
        CouponWrapper<Coupon> couponImpl = new CouponWrapper<Coupon>(coupon){

            @Override
            public boolean isValid() {
                return false;
            }
        };
        this.update(couponImpl);
    }

    @Override
    @Transactional
    public Coupon send(CouponSample couponSample, long memberId) {
        if (couponSample == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample", (Object)couponSample);
        }
        if (couponSample.getState() == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample.state", (Object)couponSample.getState());
        }
        if (!CouponSampleState.ONLINE.getId().equals(couponSample.getState().getId())) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u672a\u901a\u8fc7\u5ba1\u6279\u6216\u5df2\u5e9f\u5f03", new NameValuePair[0]);
        }
        if (couponSample.getBalanceCount() <= 0) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u5df2\u53d1\u5b8c", new NameValuePair[0]);
        }
        Integer perMemberCount = this.getCouponsCount(memberId, couponSample.getId());
        if (perMemberCount >= couponSample.getMaxPerMember()) {
            throw new WrongStateException("\u83b7\u5f97" + couponSample.getName() + "\u7684\u4f18\u60e0\u5238\u5df2\u8fbe\u5230\u4e0a\u9650\u3002", "member{id=" + memberId + "}.coupons{couponSampleId=" + couponSample.getId() + "}.size", (Object)couponSample.getMaxPerMember());
        }
        DefaultCouponSampleImpl couponSampleImpl = (DefaultCouponSampleImpl)couponSample;
        boolean ret = this.couponSampleService.decBalanceCount(couponSampleImpl);
        if (!ret) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u5df2\u53d1\u5b8c", new NameValuePair[0]);
        }
        DefaultCouponImpl coupon = new DefaultCouponImpl();
        coupon.setCouponSampleId(couponSample.getId());
        coupon.setExpireTime(couponSample.getExpireTime());
        coupon.setNote(couponSample.getNote());
        coupon.setOwnerId(memberId);
        coupon.setStartTime(couponSample.getStartTime());
        coupon.setUsed(false);
        coupon.setValid(true);
        return this.create(coupon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Boolean sendCouponList(CouponSample couponSample, Collection<Long> memberIds) {
        if (couponSample == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample", (Object)couponSample);
        }
        if (couponSample.getState() == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample.state", (Object)couponSample.getState());
        }
        if (!CouponSampleState.ONLINE.getId().equals(couponSample.getState().getId())) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u672a\u901a\u8fc7\u5ba1\u6279\u6216\u5df2\u5e9f\u5f03", new NameValuePair[0]);
        }
        if (couponSample.getBalanceCount() <= 0 || couponSample.getBalanceCount() < memberIds.size()) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u4e0d\u8db3", new NameValuePair[0]);
        }
        ArrayList<DefaultCouponImpl> clist = new ArrayList<DefaultCouponImpl>();
        for (Long memberId : memberIds) {
            DefaultCouponImpl coupon = new DefaultCouponImpl();
            coupon.setCouponSampleId(couponSample.getId());
            coupon.setExpireTime(couponSample.getExpireTime());
            coupon.setNote(couponSample.getNote());
            coupon.setOwnerId(memberId);
            coupon.setStartTime(couponSample.getStartTime());
            coupon.setUsed(false);
            coupon.setValid(true);
            clist.add(coupon);
        }
        Long startTime = System.currentTimeMillis();
        Connection conn = null;
        Statement ps = null;
        try {
            conn = ConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            StringBuffer sb = new StringBuffer();
            sb.append("INSERT INTO COUPON (COUPON_SAMPLE_ID, OWNER_ID, IS_USED,").append(" IS_VALID, NOTE, START_TIME,EXPIRE_TIME, CREATE_TIME) ").append(" VALUES (?,?,?,?,?,?,?,?) ");
            int i1 = 1;
            int i2 = 2;
            int i3 = 3;
            int i4 = 4;
            int i5 = 5;
            int i6 = 6;
            int i7 = 7;
            int i8 = 8;
            ps = conn.prepareStatement(sb.toString());
            for (Coupon coupon : clist) {
                ps.setLong(i1, coupon.getCouponSampleId());
                ps.setLong(i2, coupon.getOwnerId());
                ps.setInt(i3, coupon.isUsed() ? 1 : 0);
                ps.setInt(i4, coupon.isValid() ? 1 : 0);
                ps.setString(i5, coupon.getNote());
                ps.setTimestamp(i6, new Timestamp(coupon.getStartTime() != null ? Long.valueOf(coupon.getStartTime().getTime()) : null));
                ps.setTimestamp(i7, new Timestamp(coupon.getExpireTime() != null ? Long.valueOf(coupon.getExpireTime().getTime()) : null));
                ps.setTimestamp(i8, new Timestamp(new Date().getTime()));
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
            DefaultCouponSampleImpl couponSampleImpl = (DefaultCouponSampleImpl)couponSample;
            couponSampleImpl.setBalanceCount(couponSample.getBalanceCount() - clist.size());
            boolean bl = this.couponSampleService.update(couponSampleImpl);
            Long endTime = System.currentTimeMillis();
            System.out.println("OK,\u7528\u65f6\uff1a" + (endTime - startTime) / 1000L);
            ps.close();
            conn.close();
            Boolean bl2 = true;
            return bl2;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (Exception e1) {
                System.out.println("\u6279\u5904\u7406\u53d1\u751f\u5f02\u5e38" + e.getMessage());
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception se2) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception se) {
                se.printStackTrace();
            }
        }
    }

    @Override
    public Boolean update(Coupon obj) {
        return this.couponDao.update(obj);
    }

    @Override
    public void use(Coupon obj) {
        if (obj != null) {
            CouponWrapper<Coupon> coupon = new CouponWrapper<Coupon>(obj){

                @Override
                public boolean isUsed() {
                    return true;
                }
            };
            this.update(coupon);
        }
    }

    @Override
    public void use(Long couponId) {
        this.use(this.getById(couponId));
    }

    @Override
    public int getCouponsCount(long ownerId) {
        return this.getCoupons(ownerId).size();
    }

    @Override
    public int getCouponsCount(long ownerId, Long couponSampleId) {
        return this.getCoupons(ownerId, couponSampleId).size();
    }

    @Override
    public int getUsableCouponsCount(long ownerId) {
        return this.getUsableCoupons(ownerId).size();
    }

    @Override
    public int getExpiredCouponsCount(long ownerId) {
        return this.getExpiredCoupons(ownerId).size();
    }

    @Override
    public int getUsedCouponsCount(long ownerId) {
        return this.getUsedCoupons(ownerId).size();
    }

    @Override
    public Collection<Coupon> create(Collection<Coupon> coupons) {
        ArrayList list = Lists.newArrayList();
        for (Coupon coupon : coupons) {
            list.add(this.create(coupon));
        }
        return list;
    }

    @Override
    public void invalid(Collection<Coupon> coupons) {
        for (Coupon coupon : coupons) {
            this.invalid(coupon);
        }
    }

    @Override
    @Transactional
    public Collection<Coupon> send(CouponSample couponSample, Collection<Long> memberIds) {
        ArrayList list = Lists.newArrayList();
        for (Long memberId : memberIds) {
            list.add(this.send(couponSample, memberId));
        }
        return list;
    }

    @Override
    public Boolean mergeCoupon(Long mainId, Long subId) {
        return this.couponDao.mergeCoupon(mainId, subId) > 0;
    }
}

