package com.thebeastshop.pegasus.component.coupon.dao;

import java.util.Collection;
import java.util.List;

import com.thebeastshop.pegasus.component.coupon.condition.CouponCondition;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCount;
import com.thebeastshop.support.exception.WrongArgException;

/**
 * @author Liang Wenjian
 */
public interface CouponDao {

	/**
	 * 根据id获取优惠券
	 * 
	 * @param id
	 * @return
	 */
	Coupon getById(final long id);

	/**
	 * 获取优惠券列表
	 * 
	 * @param ownerId
	 * @return
	 */
	List<Coupon> getCoupons(final long ownerId);

	/**
	 * 获取优惠券的数量
	 * 
	 * @param ownerId
	 * @return
	 */
	int getCouponsCount(final long ownerId);

	/**
	 * 根据优惠券模板id获取优惠券列表
	 * 
	 * @param ownerId
	 * @return
	 */
	List<Coupon> getCoupons(final long ownerId, final Long couponSampleId);

	/**
	 * 根据优惠券模板id获取优惠券的数量
	 * 
	 * @param ownerId
	 * @return
	 */
	int getCouponsCount(final long ownerId, final Long couponSampleId);

	/**
	 * 获取可用的优惠券列表
	 *
	 * @param ownerId
	 * @return
	 */
	List<Coupon> getUsableCoupons(final long ownerId);

	/**
	 * 获取可用的优惠券的数量
	 *
	 * @param ownerId
	 * @return
	 */
	int getUsableCouponsCount(final long ownerId);

	/**
	 * 获取过期的优惠券列表
	 *
	 * @param ownerId
	 * @return
	 */
	List<Coupon> getExpiredCoupons(final long ownerId);

	/**
	 * 获取已过期的优惠券数量
	 *
	 * @param ownerId
	 * @return
	 */
	 int getExpiredCouponsCount(final long ownerId) ;

	/**
	 * 获取已用的优惠券列表
	 *
	 * @param ownerId
	 * @return
	 */
	List<Coupon> getUsedCoupons(final long ownerId);

	/**
	 * 获取已使用的优惠券数量
	 *
	 * @param ownerId
	 * @return
	 */
	 int getUsedCouponsCount(final long ownerId) ;

	/**
	 * 根据条件获取优惠券列表
	 * 
	 * @param condition
	 * @return
	 */
	List<Coupon> getCouponsByCondition(CouponCondition condition);


	/**
	 * 根据条件统计优惠券
	 *
	 * @param condition
	 * @return
     */
	CouponCount countCouponByCondition(CouponCondition condition);

	/**
	 * 创建一个优惠券.
	 *
	 * @param coupon
	 * @return
	 * @throws WrongArgException
	 *             若所创建的优惠券的样板对每个会员的数量有限制，且要发给的会员已达到限制
	 */
	Coupon create(Coupon coupon);

	/**
	 * 创建一批优惠券。
	 *
	 * @param coupons
	 * @return
	 */
	 Collection<Coupon> create(final Collection<Coupon> coupons) ;

	/**
	 * 更新优惠券
	 * 
	 * @param obj
	 * @return
	 */
	Boolean update(Coupon obj);

	/**
	 * 合并优惠券
	 * @param mainId 主账号
	 * @param subId 子账号
	 * @return
	 */
	Integer mergeCoupon(Long mainId, Long subId);
}
