package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.HasIdGetter;
import com.thebeastshop.support.mark.HasName;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Desc:适用商品范围枚举类
 * Created by hafiz.zhang on 2016/8/12.
 */
public enum ProductScope  implements HasIdGetter.HasIntIdGetter, HasName {
    /**
     * 多商品活动
     */
    MULTI(2, "指定商品"),
    /**
     * 全场活动
     */
    GLOBAL(3, "全场适用");

    private final Integer id;
    private final String name;

    public static final List<ProductScope> ALL = Collections.unmodifiableList(Arrays.asList(values()));


    ProductScope(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
