package com.thebeastshop.pegasus.component.coupon.condition;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleEntityExample.Criteria;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 优惠券模板查询条件
 * 
 * @author Paul-xiong
 *
 */
public class CouponSampleCondition {

	private Long id;

	private Integer couponType;

	private String name;

	private Integer stateId;

	private List<String> couponTypes;
	private List<String> sendWays;
	private String nickName;
	private String couponCode;
	private List<Integer> stateIds;

	public List<Integer> getStateIds() {
		return stateIds;
	}

	public void setStateIds(List<Integer> stateIds) {
		this.stateIds = stateIds;
	}

	public void fillCriteria(Criteria criteria) {
		if (id != null) {
			criteria.andIdEqualTo(id);
		}
		if (couponType != null) {
			criteria.andCouponTypeEqualTo(couponType);
		}
		if (StringUtils.isNotEmpty(name)) {
			criteria.andNameLike(name);
		}
		if (stateId != null) {
			if (stateId == CouponSampleState.FINISH.getId()) {
				criteria.andBalanceCountEqualTo(0);
				criteria.andStateIdIn(Arrays.asList(new Integer[]{4, 5}));
			}else if(stateId == 1){
				criteria.andBalanceCountEqualTo(0);
				criteria.andStateIdIn(Arrays.asList(new Integer[]{1, 6}));
			}
			else {
				criteria.andStateIdEqualTo(stateId);
			}
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getCouponType() {
		return couponType;
	}

	public void setCouponType(Integer couponType) {
		this.couponType = couponType;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getStateId() {
		return stateId;
	}

	public void setStateId(Integer stateId) {
		this.stateId = stateId;
	}

	public List<String> getCouponTypes() {
		return couponTypes;
	}

	public void setCouponTypes(List<String> couponTypes) {
		this.couponTypes = couponTypes;
	}

	public List<String> getSendWays() {
		return sendWays;
	}

	public void setSendWays(List<String> sendWays) {
		this.sendWays = sendWays;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public String getCouponCode() {
		return couponCode;
	}

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}
}
