package com.thebeastshop.pegasus.component.coupon.service;

import java.util.List;

import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;

/**
 * 
 * @author Paul-xiong
 *
 */
public interface CouponCodeService {
	/**
	 * 根据优惠券模板生成优惠码
	 * 
	 * @param couponSampleId
	 *            优惠券模板id
	 * @param count
	 *            生成数量
	 * @param creatorId
	 *            操作人id
	 * @return
	 */
	List<CouponCode> generate(long couponSampleId, int count, long creatorId);

	/**
	 * 创建优惠码
	 * 
	 * @param obj
	 * @return
	 */
	CouponCode create(CouponCode obj);

	/**
	 * 创建一批优惠码
	 * 
	 * @param objs
	 * @return
	 */
	List<CouponCode> create(List<CouponCode> objs);

	/**
	 * 根据优惠口令获取优惠码
	 * 
	 * @param code
	 *            优惠口令
	 * @return
	 */
	List<CouponCode> getByCode(String code);

	/**
	 * 根据优惠口令获取有效优惠码
	 * 
	 * @param code
	 * @return
	 */
	CouponCode getValidByCode(String code);

	CouponCode getByCouponSampleId(Long id);

	Integer countOf(CouponSample obj);

	/**
	 * 查找是否存在相同优惠码
	 *
	 * @param code
	 *
	 * @return
	 */
	boolean isExistsSameCode(String code);
}
