/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.dao.CouponCodeDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponCodeImpl;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeEntityExample;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CouponCodeDaoImpl
implements CouponCodeDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CouponCodeEntityMapper mapper;

    private CouponCodeEntity domain2Entity(CouponCode obj) {
        CouponCodeEntity entity = new CouponCodeEntity();
        entity.setCode(obj.getCode());
        entity.setCouponSampleId(obj.getCouponSampleId());
        entity.setCreateTime(obj.getCreateTime());
        entity.setCreatorId(obj.getCreatorId());
        entity.setId(obj.getId());
        entity.setNote(obj.getNote());
        return entity;
    }

    private CouponCode entity2Domain(CouponCodeEntity entity) {
        if (entity != null) {
            DefaultCouponCodeImpl obj = new DefaultCouponCodeImpl();
            obj.setCode(entity.getCode());
            obj.setCouponSampleId(entity.getCouponSampleId());
            obj.setCreateTime(entity.getCreateTime());
            obj.setCreatorId(entity.getCreatorId());
            obj.setId(entity.getId());
            obj.setNote(entity.getNote());
            return obj;
        }
        return null;
    }

    private List<CouponCode> entity2Domain(List<CouponCodeEntity> entities) {
        ArrayList domains = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (CouponCodeEntity entity : entities) {
                domains.add(this.entity2Domain(entity));
            }
        }
        return domains;
    }

    @Override
    public CouponCode create(CouponCode obj) {
        this.logger.info("Creating CouponCode: {}", (Object)obj);
        CouponCodeEntity entity = this.domain2Entity(obj);
        if (entity != null) {
            entity.setCreateTime(new Date());
            int count = this.mapper.insertSelective(entity);
            if (count > 0) {
                obj = this.entity2Domain(entity);
                this.logger.info("Created CouponCode: {}", (Object)obj);
                return obj;
            }
        }
        return null;
    }

    @Override
    public List<CouponCode> create(List<CouponCode> objs) {
        this.logger.info("Creating CouponCodes: {}", objs);
        ArrayList entitys = Lists.newArrayList();
        for (CouponCode couponCode : objs) {
            CouponCodeEntity entity = this.domain2Entity(couponCode);
            entity.setCreateTime(new Date());
            entitys.add(entity);
        }
        int count = this.mapper.insertList(entitys);
        if (count > 0) {
            ArrayList rtObjs = Lists.newArrayList();
            for (CouponCodeEntity entity : entitys) {
                rtObjs.add(this.entity2Domain(entity));
            }
            this.logger.info("Created CouponCodes: {}", (Object)rtObjs);
            return rtObjs;
        }
        return Lists.newArrayList();
    }

    @Override
    public Integer count(String code) {
        CouponCodeEntityExample example = new CouponCodeEntityExample();
        example.createCriteria().andCodeEqualTo(code);
        return this.mapper.countByExample(example);
    }

    @Override
    public Integer countOf(CouponSample couponSample) {
        return this.mapper.countOfSample(couponSample);
    }

    @Override
    public List<CouponCode> getByCode(String code) {
        CouponCodeEntityExample example = new CouponCodeEntityExample();
        example.createCriteria().andCodeEqualTo(code);
        List<CouponCodeEntity> list = this.mapper.selectByExample(example);
        return this.entity2Domain(list);
    }

    @Override
    public CouponCode getValidByCode(String code) {
        return this.entity2Domain(this.mapper.selectValidByCode(code));
    }

    @Override
    public CouponCode getByCouponSampleId(Long id) {
        CouponCodeEntityExample example = new CouponCodeEntityExample();
        example.createCriteria().andCouponSampleIdEqualTo(id);
        List<CouponCodeEntity> list = this.mapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return this.entity2Domain(list.get(0));
        }
        return null;
    }

    @Override
    public Integer getSameCodeCount(String code) {
        return this.mapper.getSameCodeCount(code);
    }
}

