package com.thebeastshop.pegasus.component.coupon.dao.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.thebeastshop.pegasus.component.coupon.enums.ProductScope;
import com.thebeastshop.support.coll.CollectionUtil;
import com.thebeastshop.support.util.EnumUtil;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.enums.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponSampleDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSampleEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.CouponContent;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponSampleImpl;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.enums.CouponType;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleEntityExample;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.WrongEntityException;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.util.JsonUtil;

/**
 * @author Liang Wenjian
 */
@Service
public class CouponSampleDaoImpl implements CouponSampleDao {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private CouponSampleEntityMapper mapper;

	/**
	 * CouponSample to CouponSampleEntity
	 * 
	 * @param obj
	 *            CouponSample对象
	 * @return
	 */
	private CouponSampleEntity domain2Entity(CouponSample obj) {
		CouponSampleEntity entity = null;
		try {
			entity = new CouponSampleEntity();
			if (CollectionUtils.isNotEmpty(obj.getAccessWays())) {
				StringBuilder strAccessWays = new StringBuilder();
				strAccessWays.append(",");
				for (AccessWay aw : obj.getAccessWays()) {
					strAccessWays.append(aw.getId()).append(",");
				}
				entity.setAccessWays(strAccessWays.toString());
			}
			entity.setBalanceCount(obj.getBalanceCount());
			CouponContent couponContent = obj.getCouponContent();
			if (couponContent != null) {
				entity.setCouponContent(JsonUtil.toJson(couponContent));
			}
			if (obj.getCouponSendWay() != null) {
				entity.setCouponSendWay(obj.getCouponSendWay().getId());
			}
			if (obj.getCouponType() != null) {
				entity.setCouponType(obj.getCouponType().getId());
			}
			entity.setCreateTime(obj.getCreateTime());
			entity.setCreatorId(obj.getCreatorId());
			entity.setDescription(obj.getDescription());
			entity.setExpireTime(obj.getExpireTime());
			entity.setId(obj.getId());
			entity.setMaxCount(obj.getMaxCount());
			entity.setMaxPerMember(obj.getMaxPerMember());
			entity.setName(obj.getName());
			entity.setTitle(obj.getTitle());
			entity.setNote(obj.getNote());
			entity.setProductDesc(obj.getProductDesc());
			if(null != obj.getProductScope()) {
				entity.setProductScope(obj.getProductScope().getId());
			}
			if (CollectionUtils.isNotEmpty(obj.getProductIds())) {
//				entity.setProductIds(JsonUtil.toJson(obj.getProductIds()));
				entity.setProductIds("," + StringUtils.join(obj.getProductIds(), ",") + ",");
			}
			if (CollectionUtils.isNotEmpty(obj.getExcludeProductIds())) {
				entity.setExcludeProductIds("," + StringUtils.join(obj.getExcludeProductIds(), ",") + ",");
			}
			entity.setStartTime(obj.getStartTime());
			entity.setStateId(obj.getStateId());
		} catch (Exception e) {
			throw new WrongEntityException(this.getClass().getSimpleName() + "方法domain2Entity的异常: " + e.getMessage());
		}
		return entity;
	}

	/**
	 * CouponSampleEntity to CouponSample
	 * 
	 * @param entity
	 *            CouponSampleEntity对象
	 * @return
	 */
	private CouponSample entity2Domain(CouponSampleEntity entity) {
		DefaultCouponSampleImpl obj = null;
		try {
			obj = new DefaultCouponSampleImpl();
			if (StringUtils.isNotBlank(entity.getAccessWays())) {
				List<AccessWay> accessWays = Lists.newArrayList();
				List<String> list = Arrays.asList(entity.getAccessWays().split(","));
				for (String str : list) {
					if (StringUtils.isNotEmpty(str)) {
						accessWays.add(AccessWay.valueOf(Integer.parseInt(str)));
					}
				}
				obj.setAccessWays(accessWays);
			}
			String prodStrIds = entity.getProductIds();
			if (StringUtils.isNotEmpty(prodStrIds)) {
				List<Long> prodIds = Lists.newArrayList();
				List<String> list = Arrays.asList(prodStrIds.split(","));
				for (String str : list) {
					if (StringUtils.isNotEmpty(str)) {
						try {
							prodIds.add(Long.parseLong(str));
						} catch (Exception ex) {
						}
					}
				}
				obj.setProductIds(prodIds);
			}
			String exProdStrIds = entity.getExcludeProductIds();
			if (StringUtils.isNotEmpty(exProdStrIds)) {
				List<Long> exProdIds = Lists.newArrayList();
				List<String> list = Arrays.asList(exProdStrIds.split(","));
				for (String str : list) {
					if (StringUtils.isNotEmpty(str)) {
						try {
							exProdIds.add(Long.parseLong(str));
						} catch (Exception ex) {
						}
					}
				}
				obj.setExcludeProductIds(exProdIds);
			}
			obj.setBalanceCount(entity.getBalanceCount());
			obj.setCouponContent(entity.getCouponContent());
			obj.setCouponSendWay(CouponSendWay.valueOf(entity.getCouponSendWay()));
			obj.setCouponType(CouponType.valueOf(entity.getCouponType()));
			obj.setCreateTime(entity.getCreateTime());
			obj.setCreatorId(entity.getCreatorId());
			obj.setDescription(entity.getDescription());
			obj.setExpireTime(entity.getExpireTime());
			obj.setId(entity.getId());
			obj.setMaxCount(entity.getMaxCount());
			obj.setMaxPerMember(entity.getMaxPerMember());
			obj.setName(entity.getName());
			obj.setTitle(entity.getTitle());
			obj.setNote(entity.getNote());
			obj.setProductDesc(entity.getProductDesc());
			if(null != entity.getProductScope()) {
				obj.setProductScope(EnumUtil.valueOf(entity.getProductScope(), ProductScope.class));
			}
			if (entity.getProductIds() != null) {
				obj.setProductIds(parseIds(entity.getProductIds()));
			}
			obj.setStartTime(entity.getStartTime());
			obj.setStateId(entity.getStateId());
		} catch (Exception e) {
			throw new WrongEntityException(this.getClass().getSimpleName() + "方法entity2Domain的异常: " + e.getMessage());
		}
		return obj;
	}


	private List<Long> parseIds(String strIds) {
		if (StringUtils.isEmpty(strIds)) {
			return Lists.newArrayList();
		}
		List<Long> results = Lists.newArrayList();
		String[] strIdArr = strIds.split(",");
		for (String strId : strIdArr) {
			if (StringUtils.isNotEmpty(strId)) {
				try {
					results.add(Long.valueOf(strId));
				} catch (Exception ex) {
				}
			}
		}
		return results;
	}


	private List<CouponSample> entity2Domain(List<CouponSampleEntity> entities) {
		List<CouponSample> domains = Lists.newArrayList();
		for (CouponSampleEntity entity : entities) {
			domains.add(entity2Domain(entity));
		}
		return domains;
	}

	@Override
	public CouponSample create(CouponSample obj) {
		logger.info("Creating CouponSample: {}", obj);

		CouponSampleEntity entity = this.domain2Entity(obj);
		if (entity != null) {
			entity.setCreateTime(new Date());
			int count = this.mapper.insertSelective(entity);

			if (count > 0) {
				obj = this.entity2Domain(entity);
				logger.info("Created CouponSample: {}", obj);
				return obj;
			}
		}

		return null;
	}

	@Override
	public boolean update(CouponSample obj) {
		logger.info("Updating CouponSample: {}", obj);

		CouponSampleEntity entity = this.domain2Entity(obj);
		if (entity != null) {
			int count = this.mapper.updateByPrimaryKeySelective(entity);

			if (count > 0) {
				logger.info("Updated CouponSample: {}", obj);
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean decBalanceCount(CouponSample obj) {
		CouponSampleEntity entity = this.domain2Entity(obj);
		if (entity != null) {
			int count = this.mapper.decBalanceCount(entity);
			if (count > 0) {
				logger.info("Updated CouponSample: {}", obj);
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean delete(Long id) {
		return false;
	}

	@Override
	public CouponSample getById(final long id) {
		return this.entity2Domain(this.mapper.selectByPrimaryKey(id));
	}

	@Override
	public List<State> getStates() {
		return Lists.<State> newArrayList(CouponSampleState.values());
	}

	@Override
	public List<CouponSendWay> getCouponSendWays() {
		return Arrays.asList(CouponSendWay.values());
	}

	@Override
	public List<AccessWay> getAccessWays() {
		return Arrays.asList(AccessWay.values());
	}

	@Override
	public List<CouponSample> getByCondition(CouponSampleCondition condition) {
		CouponSampleEntityExample example = new CouponSampleEntityExample();
		condition.fillCriteria(example.createCriteria());
		example.setOrderByClause("create_time DESC");
		List<CouponSampleEntity> entityList = this.mapper.selectByExample(example);
		return entity2Domain(entityList);
	}

	@Override
	public List<CouponSample> getFirstPendingCouponSample() {
		return entity2Domain(this.mapper.getFirstPendingCouponSample());
	}

	@Override
	public List<CouponSample> getSecondPendingCouponSample() {
		return entity2Domain(this.mapper.getSecondPendingCouponSample());
	}

	@Override
	public List<CouponSample> getFirstApprovaledCouponSample() {
		return entity2Domain(this.mapper.getApprovaledCouponSample(1));
	}

	@Override
	public List<CouponSample> getSecondApprovaledCouponSample() {
		return entity2Domain(this.mapper.getApprovaledCouponSample(2));
	}

	@Override
	public Integer changeCouponSampleState(Long id, Integer state) {
		CouponSampleEntity entity = new CouponSampleEntity();
		entity.setId(id);
		entity.setStateId(state);
		return this.mapper.updateByPrimaryKeySelective(entity);
	}

	@Override
	public Integer submitApproval(Long id) {
		CouponSampleEntity entity = new CouponSampleEntity();
		entity.setId(id);
		entity.setStateId(1);
		return this.mapper.updateByPrimaryKeySelective(entity);
	}

	@Override
	public CouponSample checkById(long id) {
		final CouponSample one = getById(id);
		if (one == null) {
			throw new NoSuchResourceException("优惠券样板", id);
		}
		return one;
	}

}
