package com.thebeastshop.pegasus.component.coupon.domain.impl;

import java.util.Date;

import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.support.mark.Wrapper;

/**
 * @author Liang Wenjian
 */
public class CouponWrapper<T extends Coupon> extends CouponTemplate implements Wrapper<T> {

	private final T raw;

	public CouponWrapper(final T raw) {
		this.raw = raw;
	}

	public String getNote() {
		return raw.getNote();
	}

	public Long getOwnerId() {
		return raw.getOwnerId();
	}

	public boolean isValid() {
		return raw.isValid();
	}

	public Date getCreateTime() {
		return raw.getCreateTime();
	}

	public Date getExpireTime() {
		return raw.getExpireTime();
	}

	public boolean isExpired() {
		return raw.isExpired();
	}

	public Long getCouponSampleId() {
		return raw.getCouponSampleId();
	}

	public boolean isUsed() {
		return raw.isUsed();
	}

	public Date getStartTime() {
		return raw.getStartTime();
	}

	public boolean isAvailable() {
		return raw.isAvailable();
	}

	@Override
	public CouponSample getCouponSample() {
		return raw.getCouponSample();
	}

	public Long getId() {
		return raw.getId();
	}

	@Override
	public T unwrap() {
		return raw;
	}
}
