package com.thebeastshop.pegasus.component.coupon.dao;

import java.util.List;

import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;

/**
 * 
 * @author Paul-xiong
 *
 */
public interface CouponCodeDao {
	/**
	 * 创建优惠码
	 * 
	 * @param obj
	 * @return
	 */
	CouponCode create(CouponCode obj);

	/**
	 * 创建一批优惠码
	 * 
	 * @param objs
	 * @return
	 */
	List<CouponCode> create(List<CouponCode> objs);

	/**
	 * 计数
	 *
	 * @param code
	 * @return
     */
	Integer count(String code);


	Integer countOf(CouponSample couponSample);
	
	/**
	 * 根据优惠口令获取优惠码
	 * 
	 * @param code
	 *            优惠口令
	 * @return
	 */
	List<CouponCode> getByCode(String code);
	
	/**
	 * 根据优惠口令获取有效优惠码
	 * 
	 * @param code
	 * @return
	 */
	CouponCode getValidByCode(String code);

	CouponCode getByCouponSampleId(Long id);

	/**
	 * 查找是否存在相同的优惠码
	 *
	 * @param code
	 *
	 * @return
	 */
	Integer getSameCodeCount(String code);
}
