/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.enums;

import com.thebeastshop.common.enums.CodeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum TransportContainerStatusEnum implements CodeEnum<Integer>
{
    INITIAL(1, "\u521d\u59cb"),
    WAIT_TRUCK_LOADING(2, "\u5f85\u88c5\u8f66"),
    IN_TRANSIT(3, "\u8fd0\u8f93\u4e2d"),
    UNLOADED(4, "\u5df2\u5378\u8f66"),
    PUTAWAY_FINISHED(5, "\u4e0a\u67b6\u5b8c\u6210"),
    EXCEPTION_TO_BE_HANDLED(6, "\u5f02\u5e38\u5f85\u5904\u7406"),
    CANCEL(7, "\u4f5c\u5e9f");

    private Integer code;
    private String name;
    public static final List<TransportContainerStatusEnum> ALL;

    private TransportContainerStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static String getName(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).map(TransportContainerStatusEnum::getName).findAny().orElse("");
    }

    public static TransportContainerStatusEnum getEnum(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).findAny().orElse(null);
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(TransportContainerStatusEnum.values()));
    }
}

