/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.constant;

import com.thebeastshop.wms.constant.WMSConstants;
import java.util.Random;

public final class ExpressHelper {
    private static final Random random = new Random();

    public static boolean isSf(Integer expressType) {
        return WMSConstants.ExpressType.SF_LAND.equals(expressType) || WMSConstants.ExpressType.SF_AIR.equals(expressType) || WMSConstants.ExpressType.SF_TODAY.equals(expressType) || WMSConstants.ExpressType.SF_COLD_CHAIN.equals(expressType);
    }

    public static boolean isEms(Integer expressType) {
        return WMSConstants.ExpressType.EMS_LAND.equals(expressType) || WMSConstants.ExpressType.EMS_AIR.equals(expressType);
    }

    public static boolean isEmsLand(Integer expressType) {
        return WMSConstants.ExpressType.EMS_LAND.equals(expressType);
    }

    public static boolean isEmsAir(Integer expressType) {
        return WMSConstants.ExpressType.EMS_AIR.equals(expressType);
    }

    public static boolean isZt(Integer expressType) {
        return WMSConstants.ExpressType.ZT.equals(expressType);
    }

    public static boolean isJd(Integer expressType) {
        return WMSConstants.ExpressType.JD_AIR.equals(expressType) || WMSConstants.ExpressType.JD_LAND.equals(expressType);
    }

    public static boolean isSfIntl(Integer expressType) {
        return WMSConstants.ExpressType.SF_INTL.equals(expressType) || WMSConstants.ExpressType.SF_INTL_EC.equals(expressType);
    }

    public static boolean isFpx(Integer expressType) {
        return WMSConstants.ExpressType.FPX.equals(expressType);
    }

    public static boolean isYiTms(Integer expressType) {
        return WMSConstants.ExpressType.YI_TMS.equals(expressType);
    }

    public static String generateCode(String str, int appendLength) {
        int len = Math.max(2, appendLength);
        int maxValue = (int)Math.pow(10.0, len);
        int rand = random.nextInt(maxValue);
        return str + String.format("%0" + len + "d", rand);
    }
}

