/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.dataProps;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.wms.dataProps.DataColumn;
import com.thebeastshop.wms.dataProps.RowData;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class DataPropHelper {
    private static final Logger log = LoggerFactory.getLogger(DataPropHelper.class);
    private static final DefaultConversionService conversionService = new DefaultConversionService();

    public static <T> List<DataItem> extract(T data) {
        if (data == null) {
            return new ArrayList<DataItem>();
        }
        log.info("extract data : {}", (Object)JSON.toJSONString(data));
        IdGenerator idGenerator = new IdGenerator();
        ExtraWrap wrap = new ExtraWrap();
        wrap.data = data;
        DataItem dataItem = DataPropHelper.doExtract(wrap, idGenerator);
        log.info("extract dataItem : {}", (Object)JSON.toJSONString((Object)dataItem));
        List<DataItem> flatDataItemList = DataPropHelper.flatDataItemTree(dataItem);
        log.info("extract flatDataItemList : {}", (Object)JSON.toJSONString(flatDataItemList));
        return flatDataItemList.stream().filter(item -> EmptyUtil.isNotEmpty((String)item.getConfigValue())).collect(Collectors.toList());
    }

    public static <T> void merge(T data, List<DataItem> flatDataItemList) {
        if (NullUtil.isNull(data) || EmptyUtil.isEmpty(flatDataItemList)) {
            return;
        }
        log.info("merge flatDataItemList : {}", (Object)JSON.toJSONString(flatDataItemList));
        DataItem dataItem = DataPropHelper.toDataItemTree(flatDataItemList);
        log.info("merge dataItem : {}", (Object)JSON.toJSONString((Object)dataItem));
        DataPropHelper.doMerge(data, dataItem);
        log.info("merge data : {}", (Object)JSON.toJSONString(data));
    }

    public static <T, R> void addConverter(Converter<T, R> converter) {
        conversionService.addConverter(converter);
    }

    private static <T> void doMerge(T data, DataItem dataItem) {
        if (data == null || EmptyUtil.isEmpty(dataItem.getSubItemList())) {
            return;
        }
        List filedItemList = dataItem.subItemList;
        Map filedItemMap = filedItemList.stream().collect(Collectors.toMap(DataItem::getDataPath, Function.identity(), (f1, f2) -> f1));
        ReflectionUtils.doWithFields(data.getClass(), field -> {
            DataColumn dataColumnAnnotation = field.getAnnotation(DataColumn.class);
            if (dataColumnAnnotation == null) {
                return;
            }
            String dataPropCode = dataColumnAnnotation.value() != null && !"".equals(dataColumnAnnotation.value()) ? dataColumnAnnotation.value() : field.getName();
            DataItem filedDateItem = (DataItem)filedItemMap.get(dataPropCode);
            if (NullUtil.isNull((Object)filedDateItem)) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            ResolvableType resolvableType = ResolvableType.forField((Field)field);
            Class fieldType = resolvableType.getRawClass();
            if (ClassUtils.isAssignable(Collection.class, (Class)fieldType)) {
                if (EmptyUtil.isNotEmpty(filedDateItem.getSubItemList())) {
                    Class elementType = resolvableType.getGeneric(new int[]{0}).getRawClass();
                    Collection collection = DataPropHelper.instanceCollection(fieldType);
                    filedDateItem.subItemList.forEach(elementDataItem -> {
                        Object element = DataPropHelper.convertData(elementType, elementDataItem);
                        if (element != null) {
                            collection.add(element);
                        }
                    });
                    ReflectionUtils.setField((Field)field, (Object)data, collection);
                }
            } else {
                Object fieldValue = DataPropHelper.convertData(fieldType, filedDateItem);
                ReflectionUtils.setField((Field)field, (Object)data, (Object)fieldValue);
            }
        });
    }

    private static <T> Object convertData(Class<T> type, DataItem dataItem) {
        if (EmptyUtil.isEmpty((String)dataItem.getConfigValue()) && EmptyUtil.isEmpty(dataItem.getSubItemList())) {
            return null;
        }
        if (DataPropHelper.dataAnnotation(type)) {
            T element = DataPropHelper.newInstance(type);
            DataPropHelper.doMerge(element, dataItem);
            return element;
        }
        return DataPropHelper.string2Data(dataItem.getConfigValue(), type);
    }

    private static <T> DataItem doExtract(ExtraWrap<T> wrap, IdGenerator idGenerator) {
        Object data = wrap.data;
        DataItem dataItem = new DataItem();
        dataItem.configType = wrap.configType;
        dataItem.dataPath = wrap.dataPath;
        dataItem.dataId = idGenerator.next();
        dataItem.configDesc = wrap.dataColumnAnnotation != null ? wrap.dataColumnAnnotation.name() : "";
        if (data == null) {
            return dataItem;
        }
        if (data instanceof Iterable) {
            dataItem.configType = String.format("%s_Collection", wrap.configType);
            dataItem.configValue = "L[placeholder]";
            ArrayList containerItemList = new ArrayList();
            ((Iterable)data).forEach(item -> {
                ExtraWrap itemWrap = new ExtraWrap();
                itemWrap.data = item;
                itemWrap.configType = wrap.configType;
                itemWrap.dataPath = wrap.dataPath;
                itemWrap.dataColumnAnnotation = wrap.dataColumnAnnotation;
                DataItem containerItem = DataPropHelper.doExtract(itemWrap, idGenerator);
                containerItem.parentDataId = dataItem.dataId;
                containerItemList.add(containerItem);
            });
            dataItem.subItemList = containerItemList;
            return dataItem;
        }
        if (!DataPropHelper.dataAnnotation(data.getClass())) {
            dataItem.configValue = DataPropHelper.data2String(data);
            return dataItem;
        }
        dataItem.configType = String.format("%s_Object", wrap.configType);
        dataItem.configValue = "{placeholder}";
        dataItem.subItemList = new ArrayList();
        ReflectionUtils.doWithFields(data.getClass(), field -> {
            DataColumn dataColumnAnnotation = field.getAnnotation(DataColumn.class);
            if (dataColumnAnnotation == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = ReflectionUtils.getField((Field)field, (Object)data);
            if (fieldValue == null) {
                return;
            }
            String propCode = EmptyUtil.isNotEmpty((String)dataColumnAnnotation.value()) ? dataColumnAnnotation.value() : field.getName();
            String configType = DataPropHelper.buildCode(wrap.configType, propCode);
            ExtraWrap fieldWrap = new ExtraWrap();
            fieldWrap.data = fieldValue;
            fieldWrap.configType = configType;
            fieldWrap.dataPath = propCode;
            fieldWrap.dataColumnAnnotation = dataColumnAnnotation;
            DataItem fieldItem = DataPropHelper.doExtract(fieldWrap, idGenerator);
            fieldItem.parentDataId = dataItem.dataId;
            fieldItem.configDesc = dataColumnAnnotation.name();
            dataItem.subItemList.add(fieldItem);
        });
        return dataItem;
    }

    private static DataItem toDataItemTree(List<DataItem> flatDataItemList) {
        Map<Integer, List<DataItem>> subDataItemMap = flatDataItemList.stream().collect(Collectors.groupingBy(DataItem::getParentDataId));
        DataItem dataItem = new DataItem();
        dataItem.dataId = 0;
        DataPropHelper.buildChildren(dataItem, subDataItemMap);
        return dataItem;
    }

    private static void buildChildren(DataItem colItem, Map<Integer, List<DataItem>> subDataItemMap) {
        List<DataItem> children = subDataItemMap.get(colItem.getDataId());
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        children.forEach(item -> DataPropHelper.buildChildren(item, subDataItemMap));
        colItem.subItemList = children;
    }

    private static List<DataItem> flatDataItemTree(DataItem dataItem) {
        ArrayList<DataItem> list = new ArrayList<DataItem>();
        if (dataItem.dataId > 0) {
            list.add(dataItem);
        }
        if (EmptyUtil.isNotEmpty(dataItem.getSubItemList())) {
            dataItem.getSubItemList().forEach(colItem -> list.addAll(DataPropHelper.flatDataItemTree(colItem)));
            dataItem.setSubItemList(null);
        }
        return list;
    }

    private static String buildCode(String pcode, String code) {
        return pcode == null || "".equals(pcode) ? code : pcode + "." + code;
    }

    private static <T> T string2Data(String str, Class<T> clazz) {
        try {
            return (T)conversionService.convert((Object)str, clazz);
        }
        catch (Exception e) {
            log.error("string2Data fail", (Throwable)e);
            log.error("string2Data fail, try json parse : {}", (Object)str);
            return (T)JSON.parseObject((String)str, clazz);
        }
    }

    private static <T> String data2String(T data) {
        try {
            return (String)conversionService.convert(data, String.class);
        }
        catch (Exception e) {
            log.error("data2String fail, try json parse : {}", (Object)JSON.toJSONString(data));
            return JSON.toJSONString(data);
        }
    }

    private static <T> Collection<T> instanceCollection(Class<T> collectType) {
        if (collectType.isAssignableFrom(List.class)) {
            return new ArrayList();
        }
        if (collectType.isAssignableFrom(Set.class)) {
            return new HashSet();
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(ClassUtils.getQualifiedName(clazz) + " instance fail");
        }
    }

    public static boolean dataAnnotation(Class<?> clazz) {
        RowData annotation = clazz.getAnnotation(RowData.class);
        return annotation != null;
    }

    static {
        conversionService.removeConvertible(String.class, Date.class);
        conversionService.removeConvertible(Date.class, String.class);
        conversionService.addConverter((Converter)new NumberString2DataConverter());
        conversionService.addConverter((Converter)new Date2NumberStringConverter());
    }

    public static class ToJsonConverterFactory<T> {
        public Converter<T, String> newConverter(Class<T> tClass) {
            return new Converter<T, String>(){

                public String convert(T source) {
                    return JSON.toJSONString(source);
                }
            };
        }
    }

    private static class NumberString2DataConverter
    implements Converter<String, Date> {
        private NumberString2DataConverter() {
        }

        public Date convert(String source) {
            return EmptyUtil.isEmpty((String)source) ? null : new Date(Long.parseLong(source));
        }
    }

    private static class Date2NumberStringConverter
    implements Converter<Date, String> {
        private Date2NumberStringConverter() {
        }

        public String convert(Date source) {
            return source == null ? "" : source.getTime() + "";
        }
    }

    private static class ExtraWrap<T> {
        T data;
        String configType;
        String dataPath;
        DataColumn dataColumnAnnotation;

        private ExtraWrap() {
        }
    }

    private static class IdGenerator {
        private int code = 0;

        private IdGenerator() {
        }

        public int next() {
            return this.code++;
        }
    }

    public static class DataItem
    implements Serializable {
        private Integer dataId;
        private String configType;
        private String configDesc;
        private String configValue;
        private Integer parentDataId;
        private String dataPath;
        private List<DataItem> subItemList;

        public Integer getDataId() {
            return this.dataId;
        }

        public void setDataId(Integer dataId) {
            this.dataId = dataId;
        }

        public String getConfigType() {
            return this.configType;
        }

        public void setConfigType(String configType) {
            this.configType = configType;
        }

        public String getConfigDesc() {
            return this.configDesc;
        }

        public void setConfigDesc(String configDesc) {
            this.configDesc = configDesc;
        }

        public String getConfigValue() {
            return this.configValue;
        }

        public void setConfigValue(String configValue) {
            this.configValue = configValue;
        }

        public Integer getParentDataId() {
            return this.parentDataId;
        }

        public void setParentDataId(Integer parentDataId) {
            this.parentDataId = parentDataId;
        }

        public String getDataPath() {
            return this.dataPath;
        }

        public void setDataPath(String dataPath) {
            this.dataPath = dataPath;
        }

        public List<DataItem> getSubItemList() {
            return this.subItemList;
        }

        public void setSubItemList(List<DataItem> subItemList) {
            this.subItemList = subItemList;
        }
    }
}

