/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.socket.netty.server;

import com.thebeastshop.tx.socket.config.ServerConfig;
import com.thebeastshop.tx.socket.netty.server.NettySocketServerHandler;
import com.thebeastshop.tx.socket.server.SocketServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;

public class NettySocketServer
implements SocketServer {
    private int port = 6789;
    private ServerBootstrap b;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public SocketServer initServer(ServerConfig config) {
        final NettySocketServerHandler nettyServerHandler = new NettySocketServerHandler();
        nettyServerHandler.handler = config.getHandler();
        this.port = config.getPort();
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        this.b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)this.b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new ByteArrayDecoder()});
                p.addLast(new ChannelHandler[]{new ByteArrayEncoder()});
                p.addLast(new ChannelHandler[]{nettyServerHandler});
            }
        });
        return this;
    }

    public void start() {
        try {
            this.b.bind(this.port).sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

