/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.socket.netty.client;

import com.thebeastshop.tx.socket.client.SocketClientHandler;
import com.thebeastshop.tx.socket.netty.client.NettySocketClient;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettySocketClientHandler
extends SimpleChannelInboundHandler<byte[]> {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private NettySocketClient client;
    public SocketClientHandler handler;

    public NettySocketClientHandler(NettySocketClient client) {
        this.client = client;
    }

    protected void channelRead0(ChannelHandlerContext ctx, byte[] msg) throws Exception {
        if (ArrayUtils.isNotEmpty((byte[])msg) && this.handler != null) {
            this.handler.handle(msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.log.error("Connect Refuse");
        final EventLoop eventLoop = ctx.channel().eventLoop();
        eventLoop.schedule(new Runnable(){

            @Override
            public void run() {
                NettySocketClientHandler.this.client.init((EventLoopGroup)eventLoop);
            }
        }, 1L, TimeUnit.SECONDS);
        super.channelInactive(ctx);
    }
}

