/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.feign.aop;

import com.google.common.collect.Lists;
import com.thebeastshop.tx.context.MethodDefinationManager;
import com.thebeastshop.tx.context.TxContext;
import com.thebeastshop.tx.context.TxContextManager;
import com.thebeastshop.tx.context.content.InvokeContent;
import com.thebeastshop.tx.context.content.MethodContent;
import com.thebeastshop.tx.feign.exceptions.FeignException;
import com.thebeastshop.tx.feign.spring.FeignMethodScanner;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class FeignTxAspect {
    private static final Logger log = LoggerFactory.getLogger(FeignTxAspect.class);

    @Pointcut(value="@within(org.springframework.cloud.openfeign.FeignClient)")
    public void cut() {
    }

    @Around(value="cut()")
    public Object around(ProceedingJoinPoint jp) {
        TxContext txContext = null;
        if (TxContextManager.hasTxContent()) {
            txContext = TxContextManager.getTxContext();
        }
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        MethodContent methodContent = MethodDefinationManager.getMethodCentent((Method)method);
        Class interfaceClass = jp.getSignature().getDeclaringType();
        if (txContext != null && methodContent != null && Lists.newArrayList((Object[])new MethodContent.MethodContentState[]{MethodContent.MethodContentState.TCC, MethodContent.MethodContentState.TC}).contains(methodContent.getMethodContentState())) {
            log.info("[BEAST-TX]\u4e8b\u52a1ID[{}],\u5f00\u59cb\u6267\u884c\u63a5\u53e3[{}]\u7684TRY\u65b9\u6cd5[{}]", new Object[]{txContext.getTxId(), interfaceClass.getName(), methodContent.getTryMethod().getName()});
            Object bean = FeignMethodScanner.getApplicationContext().getBean(interfaceClass);
            try {
                boolean tryFlag = (Boolean)methodContent.getTryMethod().invoke(bean, jp.getArgs());
                if (!tryFlag) {
                    String errorMsg = MessageFormat.format("[BEAST-TX]\u4e8b\u52a1ID[{0}],\u6267\u884c\u63a5\u53e3[{1}]\u7684TRY\u65b9\u6cd5[{2}]\u51fa\u73b0\u5f02\u5e38", txContext.getTxId(), interfaceClass.getName(), methodContent.getTryMethod().getName());
                    throw new FeignException(errorMsg);
                }
            }
            catch (Exception e) {
                String errorMsg = MessageFormat.format("[BEAST-TX]\u4e8b\u52a1ID[{0}],\u6267\u884c\u63a5\u53e3[{1}]\u7684TRY\u65b9\u6cd5[{2}]\u51fa\u73b0\u5f02\u5e38", txContext.getTxId().toString(), interfaceClass.getName(), methodContent.getTryMethod().getName());
                throw new FeignException(errorMsg);
            }
        }
        Object result = null;
        try {
            result = jp.proceed();
        }
        catch (Throwable t) {
            String errorMsg = MessageFormat.format("[BEAST-TX]\u4e8b\u52a1ID[{0}],\u6267\u884c\u63a5\u53e3[{1}]\u65b9\u6cd5[{2}]\u51fa\u73b0\u5f02\u5e38", txContext.getTxId().toString(), interfaceClass.getName(), methodContent.getConfirmMethod().getName());
            throw new FeignException(errorMsg);
        }
        if (txContext == null) {
            return result;
        }
        if (methodContent == null) {
            return result;
        }
        InvokeContent invokeContent = this.getInvokeContent(interfaceClass, jp.getArgs(), methodContent, txContext, result);
        txContext.logInvokeContent(invokeContent);
        return result;
    }

    private InvokeContent getInvokeContent(Class interfaceClass, Object[] args, MethodContent methodContent, TxContext txContext, Object result) {
        InvokeContent invokeContent = new InvokeContent();
        invokeContent.setInterfaceClass(interfaceClass);
        invokeContent.setTxId(txContext.getTxId());
        invokeContent.setArgs(args);
        invokeContent.setResult(result);
        invokeContent.setMethodContent(methodContent);
        return invokeContent;
    }
}

