/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.dubbo.spring;

import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.thebeastshop.tx.context.MethodDefinationManager;
import com.thebeastshop.tx.dubbo.exceptions.DubboMethodScanException;
import com.thebeastshop.tx.hook.CancelInvokeHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.PriorityOrdered;

public class DubboMethodScanner
implements BeanPostProcessor,
PriorityOrdered,
ApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(DubboMethodScanner.class);
    private static ApplicationContext applicationContext = null;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (ReferenceBean.class.isAssignableFrom(bean.getClass())) {
            ReferenceBean referenceBean = (ReferenceBean)bean;
            try {
                MethodDefinationManager.registerMethod((Class)referenceBean.getObjectType());
            }
            catch (Exception e) {
                String errorMsg = "[BEAST-TX]\u626b\u63cfDUBBO\u63a5\u53e3\u7684\u65f6\u5019\u53d1\u751f\u4e86\u5f02\u5e38";
                this.log.error(errorMsg, (Throwable)e);
                throw new DubboMethodScanException(errorMsg);
            }
        }
        if (CancelInvokeHook.class.isAssignableFrom(bean.getClass())) {
            MethodDefinationManager.registerCancelInvokeHook((CancelInvokeHook)((CancelInvokeHook)bean));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        DubboMethodScanner.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

