/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.google.common.collect.Lists;
import com.thebeastshop.tx.context.MethodDefinationManager;
import com.thebeastshop.tx.context.TxContext;
import com.thebeastshop.tx.context.TxContextManager;
import com.thebeastshop.tx.context.content.InvokeContent;
import com.thebeastshop.tx.context.content.MethodContent;
import com.thebeastshop.tx.dubbo.spring.DubboMethodScanner;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"}, order=-1000)
public class DubboTxFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboTxFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TxContext txContext = null;
        if (TxContextManager.hasTxContent()) {
            txContext = TxContextManager.getTxContext();
        }
        Method method = null;
        try {
            method = this.getInvokeMethod(invoker, invocation);
        }
        catch (NoSuchMethodException e) {
            log.error("\u627e\u4e0d\u5230DUBBO\u65b9\u6cd5[{}]", (Object)invocation.getMethodName());
            throw new RpcException();
        }
        MethodContent methodContent = MethodDefinationManager.getMethodCentent((Method)method);
        if (txContext != null && methodContent != null && Lists.newArrayList((Object[])new MethodContent.MethodContentState[]{MethodContent.MethodContentState.TCC, MethodContent.MethodContentState.TC}).contains(methodContent.getMethodContentState())) {
            log.info("[BEAST-TX]\u4e8b\u52a1ID[{}],\u5f00\u59cb\u6267\u884c\u63a5\u53e3[{}]\u7684TRY\u65b9\u6cd5[{}]", new Object[]{txContext.getTxId(), invoker.getInterface().getName(), methodContent.getTryMethod().getName()});
            Object bean = DubboMethodScanner.getApplicationContext().getBean(invoker.getInterface());
            try {
                boolean tryFlag = (Boolean)methodContent.getTryMethod().invoke(bean, invocation.getArguments());
                if (!tryFlag) {
                    String errorMsg = MessageFormat.format("[BEAST-TX]\u4e8b\u52a1ID[{0}],\u6267\u884c\u63a5\u53e3[{1}]\u7684TRY\u65b9\u6cd5[{2}]\u51fa\u73b0\u5f02\u5e38", txContext.getTxId(), invoker.getInterface().getName(), methodContent.getTryMethod().getName());
                    throw new RpcException(errorMsg);
                }
            }
            catch (Exception e) {
                String errorMsg = MessageFormat.format("[BEAST-TX]\u4e8b\u52a1ID[{0}],\u6267\u884c\u63a5\u53e3[{1}]\u7684TRY\u65b9\u6cd5[{2}]\u51fa\u73b0\u5f02\u5e38", txContext.getTxId().toString(), invoker.getInterface().getName(), methodContent.getTryMethod().getName());
                throw new RpcException(errorMsg);
            }
        }
        Result result = invoker.invoke(invocation);
        if (txContext == null) {
            return result;
        }
        if (methodContent == null) {
            return result;
        }
        if (result == null || result.hasException()) {
            return result;
        }
        InvokeContent invokeContent = this.getInvokeContent(invoker, invocation, methodContent, txContext, result);
        txContext.logInvokeContent(invokeContent);
        return result;
    }

    private Method getInvokeMethod(Invoker<?> invoker, Invocation invocation) throws NoSuchMethodException {
        Class interfaceClass = invoker.getInterface();
        String methodName = invocation.getMethodName();
        Class[] paramTypes = invocation.getParameterTypes();
        return interfaceClass.getMethod(methodName, paramTypes);
    }

    private InvokeContent getInvokeContent(Invoker<?> invoker, Invocation invocation, MethodContent methodContent, TxContext txContext, Result result) {
        Class interfaceClass = invoker.getInterface();
        InvokeContent invokeContent = new InvokeContent();
        invokeContent.setInterfaceClass(interfaceClass);
        invokeContent.setTxId(txContext.getTxId());
        invokeContent.setArgs(invocation.getArguments());
        invokeContent.setResult(result.getValue());
        invokeContent.setMethodContent(methodContent);
        return invokeContent;
    }
}

