/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.dubbo.springboot;

import com.thebeastshop.tx.aop.TxAspect;
import com.thebeastshop.tx.dubbo.spring.DubboMethodScanner;
import com.thebeastshop.tx.socket.client.SocketClient;
import com.thebeastshop.tx.socket.factory.SocketClientFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;

@Configuration
public class TxDubboAutoConfiguration {
    private final String TX_MONITOR_IP = "tx.monitor.ip";
    private final String TX_MONITOR_PORT = "tx.monitor.port";

    @Bean
    @ConditionalOnProperty(prefix="tx.monitor", name={"ip", "port"})
    public SocketClientFactory socketClientFactory(Environment environment) {
        SocketClientFactory socketClientFactory = new SocketClientFactory();
        socketClientFactory.setIp(environment.getProperty("tx.monitor.ip"));
        socketClientFactory.setPort(((Integer)environment.getProperty("tx.monitor.port", Integer.class)).intValue());
        return socketClientFactory;
    }

    @Bean
    public TxAspect txAspect(@Nullable SocketClient socketClient) {
        return new TxAspect();
    }

    @Bean
    public DubboMethodScanner dubboMethodScanner() {
        return new DubboMethodScanner();
    }
}

