/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.utils;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.tx.utils.MD5Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class MethodUtil {
    public static String getMethodKey(Method method) {
        String name = MethodUtil.getMethodNameWithParameterTypes(method.getDeclaringClass(), method);
        return MD5Util.makeMD5(name);
    }

    public static String getMethodKey(Class clazz, String methodName, Class[] paramTypes) {
        String name = MethodUtil.getMethodNameWithParameterTypes(clazz, methodName, paramTypes);
        return MD5Util.makeMD5(name);
    }

    public static String getMethodNameWithParameterTypes(Class clazz, Method method) {
        return MethodUtil.getMethodNameWithParameterTypes(clazz, method.getName(), method.getParameterTypes());
    }

    public static String getMethodNameWithParameterTypes(Class clazz, String methodName, Class[] paramTypes) {
        String name = clazz.getName() + "." + methodName + "(";
        StringBuilder builder = new StringBuilder(name);
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            Class pType = paramTypes[i];
            builder.append(pType.getName());
            if (i >= len - 1) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    public static String getMethodNameWithArguments(Class clazz, String methodName, Object[] arguments) {
        String name = clazz.getName() + "." + methodName + "(";
        StringBuilder builder = new StringBuilder(name);
        int len = arguments.length;
        for (int i = 0; i < len; ++i) {
            Object arg = arguments[i];
            builder.append(JSON.toJSONString((Object)arg));
            if (i >= len - 1) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    public static String mergeMethodName(String prefix, String methodName) {
        return prefix + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
    }

    public static boolean matchParameterTypes(Method m1, Method m2, boolean wholeMatch) {
        Type[] types1 = m1.getGenericParameterTypes();
        Type[] types2 = m2.getGenericParameterTypes();
        if (types1.length == 0 || types2.length == 0) {
            return false;
        }
        if (wholeMatch) {
            if (types1.length != types2.length) {
                return false;
            }
            for (int i = 0; i < types1.length; ++i) {
                if (types1[i].equals(types2[i])) continue;
                return false;
            }
            return true;
        }
        int index = Math.min(types1.length, types2.length);
        for (int i = 0; i < index; ++i) {
            if (!types1[i].equals(types2[i])) continue;
            return true;
        }
        return false;
    }

    public static Method[] getOwnPublicMethod(Class clazz) {
        Method[] methods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            methodList.add(m);
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) throws InvocationTargetException, IllegalAccessException {
        return method.invoke(target, args);
    }

    public static Method convertToInterfaceMethod(Method method) {
        Class<?>[] interfaceArray = method.getDeclaringClass().getInterfaces();
        if (interfaceArray.length == 0) {
            return null;
        }
        Method resultMethod = null;
        for (Class<?> itface : interfaceArray) {
            try {
                resultMethod = itface.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return resultMethod;
    }
}

