package com.thebeastshop.trans.enums;

/**
 * 包裹物流状态
 */
public enum TsPackageDeclarationStatusEnum {
	/* 仓库状态 */
	NOT_SEND_WARAHOUSE(1, "未下发仓库", 1, ""),
	SEND_WARAHOUSE(2, "已下发仓库", 1, "【已发货】海外转运中"), 
	NOT_OUT_WARAHOUSE(3, "未出库", 1, ""), 
	IDENTITY_REPREAT(4, "身份证重复", 1, ""),
	FINISH_WARAHOUSE_OPRATION(	5, "仓库完成操作", 1, "【已发货】海外转运中"),
	
	/* 订单状态 */
	ORDER_NOT_CONFIRM(6, "订单未确认", 2, ""), 
	ORDER_CANCEL(7, "订单已取消", 2, ""), 
	WAIT_DECLARATION(8, "带报关", 2, ""), 
	DECLARATION_CHECK(9, "报关审核中", 2, ""), 
	DECLARATION_PASS(10, "报关通过", 2, ""),
	
	/* 支付宝报关状态,小于0表示处理异常回执 */
	ALIPAY_IN_DECLARATION(2, "电子口岸申报中", 3, ""), 
	ALIPAY_SEND_CUSTIOM_SUCCESS(3,"发送海关成功", 3, ""), 
	ALIPAY_SEND_CUSTOM_FAIL(4, "发送海关失败", 3, ""), 
	ALIPA_CUSTOM_CHARGEBACK(100, "海关退单", 3, ""), 
	ALIPAY_CUSTOM_CONCLUDE(399, "海关审结", 3, ""),
	
	/* 订单海关报关状态,小于0表示处理异常回执 */
	IN_DECLARATION(2, "订单新增申报成功", 4, ""), 
	SEND_CUSTIOM_SUCCESS(3, "发送海关成功", 4,""),
	SEND_CUSTOM_FAIL(4, "发送海关失败", 4, ""), 
	CUSTOM_CHARGEBACK(100,"海关退单", 4, ""),
	CUSTOM_IN_STORAGE(120, "海关入库", 4, "");
	
	public final int code;
	public final String name;
	public final int type;
	public final String content;

	TsPackageDeclarationStatusEnum(int code, String name, int type, String content) {
		this.code = code;
		this.name = name;
		this.type = type;
		this.content = content;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public int getType() {
		return type;
	}

	public String getContent() {
		return content;
	}


	public static TsPackageDeclarationStatusEnum getEnumByCode(Integer code) {
		for (TsPackageDeclarationStatusEnum e : TsPackageDeclarationStatusEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
