package com.thebeastshop.trans.enums;

/**
 * 不可修改地址原因枚举
 */
public enum TsReasonAddressEnum {

    CAN_MODIFY_ADDRESS("00", "可修改地址"),
    ORDER_CANCELED("01", "您的这笔订单（订单号%s）已取消。取消时间为%s。"),
    PRODUCT_CANCELED("02", "麻烦您提供下这笔订单（订单号%s）新的收件地址、姓名、电话，为您确认下是否可以修改。"),
    CHANNEL_NOT_ONLINE("03","您的这笔订单（订单号%s）非APP/小程序/野兽派官网购买，无法为您修改地址，建议您联系购买店铺咨询哦！"),
    ORDER_ADDRESS_MODIFIED("04", "麻烦您提供下这笔订单（订单号%s）新的收件地址、姓名、电话，为您确认下是否可以修改。"),
    ORDER_TYPE_SPECIAL("05", "很抱歉，这笔订单（订单号%s）不支持修改地址，原因是订单类型不支持。"),
    ORDER_STATUS_SEND("06", "由于这笔订单（订单号%s）已经发出，无法进行修改。如果还未签收，可以为您反馈快递尝试转寄，转寄会影响到您的收货时效，请您确认下。"),
    PACKAGE_PRODUCT_SEND("07", "为您确认下这笔订单（订单号%s）是否可以修改地址，请稍等。"),
    PACKAGE_DIFF_ADDRESS("08", "麻烦您提供下这笔订单（订单号%s）新的收件地址、姓名、电话，以便为您确认下是否可以修改。"),
    PACKAGE_STORE_SEND("09", "您的这笔订单（订单号XX）购买的是鲜花，麻烦提供下新的收件地址、姓名、电话，以便为您反馈花艺中心确认下是否可以修改。"),
    PRODUCT_TYPE_FLOWER("11", "您的这笔订单（订单号%s）购买的是鲜花，麻烦您提供下新的收件地址、姓名、电话，以便为您确认下是否可以修改。"),
    PRODUCT_TYPE_CUSTOMER("12", "您的这笔订单（订单号%s）购买的是定制商品，麻烦您提供下新的收件地址、姓名、电话，以便为您确认下是否可以修改。"),
    PRODUCT_TYPE_CROSS_BORDER("13", "您的这笔订单（订单号%s）购买的是有海外购商品，麻烦您提供下新的收件地址、姓名、电话，以便为您确认下是否可以修改。");

    private String code;
    private String desc;

    TsReasonAddressEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getAiAnswer(String... format) {
        if (CAN_MODIFY_ADDRESS.equals(this)) {
            return null;
        }
        return String.format(desc, format);
    }

}
