package com.thebeastshop.trans.enums;

/**
 * 不可申请售后原因枚举
 */
public enum TsReasonAfterSalesEnum {

    CAN_APPLY_REFUND("00", "可申请退换货"),
    PRODUCT_REFUND_APPLYING("01","您的这笔订单（订单号%s）已有正在进行中的售后申请，查看方式：【我的】-【全部订单】-【售后】-【查看详情】"),
    PRODUCT_REFUND_FINISHED("02","您的这笔订单（订单号%s）已有完成的售后申请，如果有什么问题可以给我说哦。"),
    CHANNEL_NOT_ONLINE("03","您的这笔订单（订单号%s）非APP/小程序/野兽派官网购买，建议您联系购买店铺咨询售后问题哦！"),
    ORDER_UN_PAY("04", "您的这笔订单（订单号%s）还未支付，可直接取消订单。在我的-全部订单-订单详情的下方选择取消订单-选择理由即可。"),
    ORDER_TYPE_SPECIAL("05", "为您确认下这笔订单（订单号%s）是否可以退换货，请稍等。"),
    ORDER_PAY_TYPE_NOT_SUPPORT("06", "很抱歉，这笔订单（订单号%s）不支持售后申请，原因是订单支付方式不支持。"),
    PACKAGE_STATUS_CANCELED("07", "您的这笔订单（订单号%s）中该商品已取消，无法售后申请了哦。"),
    PACKAGE_STATUS_RECEIVED("08", "您的这笔订单（订单号%s）包裹签收已超过7天，已经过了售后期限了，无法售后申请了哦。"),
    PACKAGE_STATUS_NOT_DELIVER("09", "您的这笔订单（订单号%s）还未发货，可直接取消订单。在我的-全部订单-订单详情的下方选择取消订单-选择理由即可。"),
    PRODUCT_TYPE_GIFT("10", "您的这笔订单（订单号%s）包含赠品，如不满足产品/活动满赠要求退货的，赠品需要一起退回"),
    PRODUCT_TYPE_FURNITURE("11", "您的这笔订单（订单号%s）购买的是大家具商品，这类商品因体积大、价值高，拆封或安装后可能导致性质改变或价值贬损，是不支持7天无理由退换货。"),
    PRODUCT_TYPE_FLOWER("12", "您的这笔订单（订单号%s）购买的是鲜花，是生鲜类商品，所以不支持7天无理由退换货。"),
    PRODUCT_TYPE_CUSTOMER("13", "您的这笔订单（订单号%s）购买的是定制商品，是下单后特别定制的，所以不支持7天无理由退换货。"),
    PRODUCT_TYPE_COMBINATION("14", "您的这笔订单（订单号%s）购买的是组合商品，为您确认下是否可以退换货，请稍等。"),
    PRODUCT_TYPE_CROSS_BORDER("15", "您的这笔订单（订单号%s）购买的是海外购商品，为您确认下是否可以退换货，请稍等。"),
    PRODUCT_TYPE_SPECIAL("16", "您的这笔订单（订单号%s）购买的商品因商品性质原因，不支持7天无理由退换货。"),
    ORDER_FUND_PAY_NOT_SUPPORT("17", "为您确认下这笔订单（订单号%s）是否可以退换货，请稍等，可能需要一些时间，稍后第一时间回复您。")
    ;


    private String code;
    private String desc;

    TsReasonAfterSalesEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getAiAnswer(String... format) {
        if(CAN_APPLY_REFUND.equals(this)) {
            return null;
        }
        return String.format(desc, format);
    }




}
