package com.thebeastshop.trans.enums;

/**
 * 订单不可取消枚举
 */
public enum TsReasonUnCancelEnum {

    CAN_CANCEL_ORDER( "00", ""),
    ORDER_CANCELED("01", "您的这笔订单（订单号为%s）已取消。取消时间为%s。"),
    PRODUCT_CANCELED("02", "为您确认下这笔订单（订单号为%s）是否可以取消处理，请稍等。"),
    CHANNEL_NOT_ONLINE("03","查询这笔订单（订单号为XX）非APP/小程序/野兽派官网购买，无法为您取消处理，建议您联系购买店铺咨询哦！"),
    ORDER_TYPE_SPECIAL("04", "为您确认下这笔订单（订单号为%s）是否可以取消处理，请稍等。"),
    ORDER_STATUS_NOT_SUPPORT("05", "您的这笔订单（订单号%s）中有商品已发货，若还未签收，可以为您反馈快递尝试拦截包裹退回。"),
    ORDER_STORE_SEND( "06","为您确认下这笔订单（订单号%s）是否可以取消处理，请稍等，若已发货还未签收，可以为您反馈快递尝试拦截包裹退回。"),
    // PRODUCT_TYPE_SPECIAL("07", "【订单中含有特殊商品】"),
    PRODUCT_TYPE_FURNITURE("07", "您的这笔订单（订单号%s）购买的是大家具商品，为您确认下是否可以取消处理，请稍等，可能需要一些时间，稍后第一时间回复您。"),
    PRODUCT_TYPE_FLOWER("08", "您的这笔订单（订单号%s）购买的是鲜花商品，为您确认下是否可以取消处理，请稍等，可能需要一些时间，稍后第一时间回复您。"),
    PRODUCT_TYPE_CUSTOMER("09", "您的这笔订单（订单号%s）购买的是定制商品，为您确认下是否可以取消处理，请稍等，可能需要一些时间，稍后第一时间回复您。"),
    PRODUCT_TYPE_JIT("10", "为您确认下这笔订单（订单号%s）是否可以取消处理，请稍等，可能需要一些时间，稍后第一时间回复您。");



    private String code;
    private String desc;

    TsReasonUnCancelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getAiAnswer(String... format) {
        if (CAN_CANCEL_ORDER.equals(this)) {
            return null;
        }
    	return String.format(desc, format);
    }

}
