package com.thebeastshop.trans.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.trans.dto.refund.RefundCreateDTO;
import com.thebeastshop.trans.dto.refund.ReturnDeliveryDTO;
import com.thebeastshop.trans.enums.TsRefundTypeEnum;
import com.thebeastshop.trans.vo.refund.*;

import java.util.List;

/**
 * 售后service
 */
public interface TsRefundService {

    /**
     * 查询售后单详情
     *
     * @param refundOrderId
     * @param memberCode
     * @return
     */
    ServiceResp<RefundInfoVO> queryDetail(Long refundOrderId, String memberCode);

    /**
     * 创建售后订单
     *
     * @return
     */
    ServiceResp<Long> create(RefundCreateDTO createDTO);

    /**
     * 补充物流单号
     *
     * @return
     */
    ServiceResp<Boolean> addReturnDelivery(ReturnDeliveryDTO createDTO);

    /**
     * 查询订单行剩余退款信息
     *
     * @return
     */
    ServiceResp<RefundRemainVO> packageSkuRemainRefund(Long packageSkuId, String memberCode);

    /**
     * 取消售后单
     *
     * @return
     */
    ServiceResp<Boolean> cancelRefundOrder(Long refundOrderId, String memberCode);

    /**
     * 查询支持的售后理由
     *
     * @return
     */
    List<RefundTypeVO> queryRefundReason(TsRefundTypeEnum refundTypeEnum);

    /**
     * 查询支持的快递公司
     *
     * @return
     */
    List<ExpressTypeVO> queryExpressType();

    /**
     * packageSkuId 查询售后商品信息
     *
     * @return
     */
    ServiceResp<PackageSkuInfoVO> getPackageSkuIdInfo(String channelCode, Long packageSkuId, String memberCode);

}
