package com.thebeastshop.trans.enums;

/**
 * 订单不可取消枚举
 */
public enum TsReasonUnCancelEnum {

    CAN_CANCEL_ORDER( "00", ""),
    ORDER_CANCELED("01", "订单状态为已取消"),
    PRODUCT_CANCELED("02", "订单中存在部分商品已取消的情况"),
    CHANNEL_NOT_ONLINE("03","非APP/小程序/野兽派官网购买。建议您联系购买店铺咨询哦！"),
    ORDER_TYPE_SPECIAL("04", "订单类型不支持"),
    ORDER_STATUS_NOT_SUPPORT("05", "订单中有商品已发货，查看方式：【我的】-【全部订单】-【查看详情】"),
    ORDER_STORE_SEND( "06","【订单部分商品已进入发货流程】"),
    PRODUCT_TYPE_SPECIAL("07", "【订单中含有鲜花/定制类/大家具等特殊商品】");

    private String code;
    private String desc;

    TsReasonUnCancelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getAiAnswer() {
    	return "经查询，不可自助取消原因：" + desc;
    }

}
