package com.thebeastshop.stock.exception;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-09-06 16:22
 */
public class SNoStockItem extends BaseDO {

    // SKU编号
    private String skuCode;
    // 剩余库存
    private Integer remainder;
    // 操作类型
    private SStockOperationTypeEnum operationType;
    // 错误消息
    private String message;

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getRemainder() {
        return remainder;
    }

    public void setRemainder(Integer remainder) {
        this.remainder = remainder;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SStockOperationTypeEnum getOperationType() {
        return operationType;
    }

    public void setOperationType(SStockOperationTypeEnum operationType) {
        this.operationType = operationType;
    }

    @Override
    public String toString() {
        return skuCode + " : " + message;
    }
}
