package com.thebeastshop.stock.exception;

import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.stock.enums.SStockErrorCodeEnum;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 业务异常：库存不足
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-08-16 14:43
 */
public class SStockNotEnoughException extends BusinessException {

    public final static String ERROR_DATA_KEY = "noStockList";

    private List<SNoStockItem> noStockList;

    public SStockNotEnoughException(List<SNoStockItem> noStockList) {
        super(SStockErrorCodeEnum.STOCK_NOT_ENOUGH);
        this.noStockList = noStockList;
    }

    public List<SNoStockItem> getNoStockList() {
        return noStockList;
    }

    public void setNoStockList(List<SNoStockItem> noStockList) {
        this.noStockList = noStockList;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder("[");

        for (int i = 0; i < noStockList.size(); i++) {
            SNoStockItem SNoStockItem = noStockList.get(i);
            builder.append(SNoStockItem.toString());
            if (i < noStockList.size() - 1) {
                builder.append(", ");
            }
        }
        builder.append("]");
        return "SKU库存不足: " + builder.toString();
    }

    @Override
    public Map<String, Object> getErrorData() {
        Map<String, Object> errorData = new HashMap<>();
        errorData.put(ERROR_DATA_KEY, noStockList);
        return errorData;
    }
}
